<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Resource_Plan_Detail_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing resource plan detail data.
 * @subpackage Structs
 */
class Project_Resource_Plan_Detail_WWS_DataType extends AbstractStructBase
{
    /**
     * The Project_Resource_Plan_Detail_ID
     * Meta information extracted from the WSDL
     * - documentation: Detail ID. This is the project resource plan detail unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Resource_Plan_Detail_ID;
    /**
     * The Project_Role_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Worker Role
     * - minOccurs: 0
     * @var \StructType\Project_RoleObjectType
     */
    public $Project_Role_Reference;
    /**
     * The Project_Role_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Role Category
     * - minOccurs: 0
     * @var \StructType\Project_Role_CategoryObjectType
     */
    public $Project_Role_Category_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The isAssociation
     * Meta information extracted from the WSDL
     * - documentation: Association
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isAssociation;
    /**
     * The Workers_Reference
     * Meta information extracted from the WSDL
     * - documentation: A subset of the possible workers from the member resource considered to be members of the resource plan detail. This may be a subset of workers for the respective member resource. If no workers are defined in the Worker Reference,
     * all workers who are members of the member resource are available for task assignment unless excluded in the Excluded Worker Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Workers_Reference;
    /**
     * The Add_Additional_Unnamed_Resources
     * Meta information extracted from the WSDL
     * - documentation: Specify the quantity of additional unnamed resources to create. | Adds the number of unnamed resources in sequence of unnamed resources specified for "Unnamed Resources"
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Add_Additional_Unnamed_Resources;
    /**
     * The Unnamed_Resource_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unnamed_Resource_WWS_DataType[]
     */
    public $Unnamed_Resource_Data;
    /**
     * The isToBeHired
     * Meta information extracted from the WSDL
     * - documentation: To Be Hired
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isToBeHired;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to reference a Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Percent_Allocation
     * Meta information extracted from the WSDL
     * - documentation: % Allocation for the Project Task Resource | Percent Allocation | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Allocation;
    /**
     * The Estimated_Hours
     * Meta information extracted from the WSDL
     * - documentation: Estimated Hours for the Project Task Resource | Estimated Hours | The estimated hours associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Estimated_Hours;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Plan Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Project_Booking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Booking Status for the Resource Plan Detail
     * - minOccurs: 0
     * @var \StructType\Project_Booking_StatusObjectType
     */
    public $Project_Booking_Status_Reference;
    /**
     * The Worker_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Member Resource Reference. Member Resource can be a Job Profile, Project Worker Role, Cost Center, Talent Pool, or Supervisory Org.
     * - minOccurs: 0
     * @var \StructType\Project_Member_ResourceObjectType
     */
    public $Worker_Group_Reference;
    /**
     * The Excluded_Workers_Reference
     * Meta information extracted from the WSDL
     * - documentation: A subset of the possible workers from the member resource considered to be members of the resource plan detail. This may be a subset of workers for the respective member resource. If no workers are defined in the Worker Reference,
     * all workers who are members of the member resource are available for task assignment unless excluded in the Excluded Worker Reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Excluded_Workers_Reference;
    /**
     * The Standard_Cost_Rate
     * Meta information extracted from the WSDL
     * - documentation: Standard Cost Rate | The standard cost rate override associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Standard_Cost_Rate;
    /**
     * The Standard_Cost_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Standard Cost Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Standard_Cost_Currency_Reference;
    /**
     * The Contract_Billing_Rate
     * Meta information extracted from the WSDL
     * - documentation: Contract Billing Ratge
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Contract_Billing_Rate;
    /**
     * The Contract_Billing_Rate_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Billing Rate Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Contract_Billing_Rate_Currency_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag for this Resource Plan Line
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Project_Resource_Plan_Detail_WWS_DataType
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setProject_Resource_Plan_Detail_ID()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setProject_Role_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setProject_Role_Category_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setStart_Date()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setEnd_Date()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setIsAssociation()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setWorkers_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setAdd_Additional_Unnamed_Resources()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setUnnamed_Resource_Data()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setIsToBeHired()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setJob_Requisition_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setPercent_Allocation()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setEstimated_Hours()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setMemo()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setProject_Booking_Status_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setWorker_Group_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setExcluded_Workers_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setStandard_Cost_Rate()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setStandard_Cost_Currency_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setContract_Billing_Rate()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setContract_Billing_Rate_Currency_Reference()
     * @uses Project_Resource_Plan_Detail_WWS_DataType::setDelete()
     * @param string $project_Resource_Plan_Detail_ID
     * @param \StructType\Project_RoleObjectType $project_Role_Reference
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param bool $isAssociation
     * @param \StructType\WorkerObjectType[] $workers_Reference
     * @param float $add_Additional_Unnamed_Resources
     * @param \StructType\Unnamed_Resource_WWS_DataType[] $unnamed_Resource_Data
     * @param bool $isToBeHired
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param float $percent_Allocation
     * @param float $estimated_Hours
     * @param string $memo
     * @param \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference
     * @param \StructType\Project_Member_ResourceObjectType $worker_Group_Reference
     * @param \StructType\WorkerObjectType[] $excluded_Workers_Reference
     * @param float $standard_Cost_Rate
     * @param \StructType\CurrencyObjectType $standard_Cost_Currency_Reference
     * @param float $contract_Billing_Rate
     * @param \StructType\CurrencyObjectType $contract_Billing_Rate_Currency_Reference
     * @param bool $delete
     */
    public function __construct($project_Resource_Plan_Detail_ID = null, \StructType\Project_RoleObjectType $project_Role_Reference = null, \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null, $start_Date = null, $end_Date = null, $isAssociation = null, array $workers_Reference = array(), $add_Additional_Unnamed_Resources = null, array $unnamed_Resource_Data = array(), $isToBeHired = null, \StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, $percent_Allocation = null, $estimated_Hours = null, $memo = null, \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference = null, \StructType\Project_Member_ResourceObjectType $worker_Group_Reference = null, array $excluded_Workers_Reference = array(), $standard_Cost_Rate = null, \StructType\CurrencyObjectType $standard_Cost_Currency_Reference = null, $contract_Billing_Rate = null, \StructType\CurrencyObjectType $contract_Billing_Rate_Currency_Reference = null, $delete = null)
    {
        $this
            ->setProject_Resource_Plan_Detail_ID($project_Resource_Plan_Detail_ID)
            ->setProject_Role_Reference($project_Role_Reference)
            ->setProject_Role_Category_Reference($project_Role_Category_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setIsAssociation($isAssociation)
            ->setWorkers_Reference($workers_Reference)
            ->setAdd_Additional_Unnamed_Resources($add_Additional_Unnamed_Resources)
            ->setUnnamed_Resource_Data($unnamed_Resource_Data)
            ->setIsToBeHired($isToBeHired)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setPercent_Allocation($percent_Allocation)
            ->setEstimated_Hours($estimated_Hours)
            ->setMemo($memo)
            ->setProject_Booking_Status_Reference($project_Booking_Status_Reference)
            ->setWorker_Group_Reference($worker_Group_Reference)
            ->setExcluded_Workers_Reference($excluded_Workers_Reference)
            ->setStandard_Cost_Rate($standard_Cost_Rate)
            ->setStandard_Cost_Currency_Reference($standard_Cost_Currency_Reference)
            ->setContract_Billing_Rate($contract_Billing_Rate)
            ->setContract_Billing_Rate_Currency_Reference($contract_Billing_Rate_Currency_Reference)
            ->setDelete($delete);
    }
    /**
     * Get Project_Resource_Plan_Detail_ID value
     * @return string|null
     */
    public function getProject_Resource_Plan_Detail_ID()
    {
        return $this->Project_Resource_Plan_Detail_ID;
    }
    /**
     * Set Project_Resource_Plan_Detail_ID value
     * @param string $project_Resource_Plan_Detail_ID
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setProject_Resource_Plan_Detail_ID($project_Resource_Plan_Detail_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Resource_Plan_Detail_ID) && !is_string($project_Resource_Plan_Detail_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Resource_Plan_Detail_ID, true), gettype($project_Resource_Plan_Detail_ID)), __LINE__);
        }
        $this->Project_Resource_Plan_Detail_ID = $project_Resource_Plan_Detail_ID;
        return $this;
    }
    /**
     * Get Project_Role_Reference value
     * @return \StructType\Project_RoleObjectType|null
     */
    public function getProject_Role_Reference()
    {
        return $this->Project_Role_Reference;
    }
    /**
     * Set Project_Role_Reference value
     * @param \StructType\Project_RoleObjectType $project_Role_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setProject_Role_Reference(\StructType\Project_RoleObjectType $project_Role_Reference = null)
    {
        $this->Project_Role_Reference = $project_Role_Reference;
        return $this;
    }
    /**
     * Get Project_Role_Category_Reference value
     * @return \StructType\Project_Role_CategoryObjectType|null
     */
    public function getProject_Role_Category_Reference()
    {
        return $this->Project_Role_Category_Reference;
    }
    /**
     * Set Project_Role_Category_Reference value
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setProject_Role_Category_Reference(\StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null)
    {
        $this->Project_Role_Category_Reference = $project_Role_Category_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get isAssociation value
     * @return bool|null
     */
    public function getIsAssociation()
    {
        return $this->isAssociation;
    }
    /**
     * Set isAssociation value
     * @param bool $isAssociation
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setIsAssociation($isAssociation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssociation) && !is_bool($isAssociation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssociation, true), gettype($isAssociation)), __LINE__);
        }
        $this->isAssociation = $isAssociation;
        return $this;
    }
    /**
     * Get Workers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorkers_Reference()
    {
        return $this->Workers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorkers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorkers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkers_ReferenceForArrayConstraintsFromSetWorkers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem) ? get_class($project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem) : sprintf('%s(%s)', gettype($project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem), var_export($project_Resource_Plan_Detail_WWS_DataTypeWorkers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $workers_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setWorkers_Reference(array $workers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($workers_ReferenceArrayErrorMessage = self::validateWorkers_ReferenceForArrayConstraintsFromSetWorkers_Reference($workers_Reference))) {
            throw new \InvalidArgumentException($workers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Workers_Reference = $workers_Reference;
        return $this;
    }
    /**
     * Add item to Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function addToWorkers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Workers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Add_Additional_Unnamed_Resources value
     * @return float|null
     */
    public function getAdd_Additional_Unnamed_Resources()
    {
        return $this->Add_Additional_Unnamed_Resources;
    }
    /**
     * Set Add_Additional_Unnamed_Resources value
     * @param float $add_Additional_Unnamed_Resources
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setAdd_Additional_Unnamed_Resources($add_Additional_Unnamed_Resources = null)
    {
        // validation for constraint: float
        if (!is_null($add_Additional_Unnamed_Resources) && !(is_float($add_Additional_Unnamed_Resources) || is_numeric($add_Additional_Unnamed_Resources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($add_Additional_Unnamed_Resources, true), gettype($add_Additional_Unnamed_Resources)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($add_Additional_Unnamed_Resources) && mb_strlen(mb_substr($add_Additional_Unnamed_Resources, false !== mb_strpos($add_Additional_Unnamed_Resources, '.') ? mb_strpos($add_Additional_Unnamed_Resources, '.') + 1 : mb_strlen($add_Additional_Unnamed_Resources))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($add_Additional_Unnamed_Resources, true), mb_strlen(mb_substr($add_Additional_Unnamed_Resources, mb_strpos($add_Additional_Unnamed_Resources, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($add_Additional_Unnamed_Resources) && $add_Additional_Unnamed_Resources < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($add_Additional_Unnamed_Resources, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($add_Additional_Unnamed_Resources) && mb_strlen(preg_replace('/(\D)/', '', $add_Additional_Unnamed_Resources)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($add_Additional_Unnamed_Resources, true), mb_strlen(preg_replace('/(\D)/', '', $add_Additional_Unnamed_Resources))), __LINE__);
        }
        $this->Add_Additional_Unnamed_Resources = $add_Additional_Unnamed_Resources;
        return $this;
    }
    /**
     * Get Unnamed_Resource_Data value
     * @return \StructType\Unnamed_Resource_WWS_DataType[]|null
     */
    public function getUnnamed_Resource_Data()
    {
        return $this->Unnamed_Resource_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setUnnamed_Resource_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnnamed_Resource_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnnamed_Resource_DataForArrayConstraintsFromSetUnnamed_Resource_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem) {
            // validation for constraint: itemType
            if (!$project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem instanceof \StructType\Unnamed_Resource_WWS_DataType) {
                $invalidValues[] = is_object($project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem) ? get_class($project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem) : sprintf('%s(%s)', gettype($project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem), var_export($project_Resource_Plan_Detail_WWS_DataTypeUnnamed_Resource_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Unnamed_Resource_Data property can only contain items of type \StructType\Unnamed_Resource_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Unnamed_Resource_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unnamed_Resource_WWS_DataType[] $unnamed_Resource_Data
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setUnnamed_Resource_Data(array $unnamed_Resource_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($unnamed_Resource_DataArrayErrorMessage = self::validateUnnamed_Resource_DataForArrayConstraintsFromSetUnnamed_Resource_Data($unnamed_Resource_Data))) {
            throw new \InvalidArgumentException($unnamed_Resource_DataArrayErrorMessage, __LINE__);
        }
        $this->Unnamed_Resource_Data = $unnamed_Resource_Data;
        return $this;
    }
    /**
     * Add item to Unnamed_Resource_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unnamed_Resource_WWS_DataType $item
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function addToUnnamed_Resource_Data(\StructType\Unnamed_Resource_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unnamed_Resource_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Unnamed_Resource_Data property can only contain items of type \StructType\Unnamed_Resource_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Unnamed_Resource_Data[] = $item;
        return $this;
    }
    /**
     * Get isToBeHired value
     * @return bool|null
     */
    public function getIsToBeHired()
    {
        return $this->isToBeHired;
    }
    /**
     * Set isToBeHired value
     * @param bool $isToBeHired
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setIsToBeHired($isToBeHired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isToBeHired) && !is_bool($isToBeHired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isToBeHired, true), gettype($isToBeHired)), __LINE__);
        }
        $this->isToBeHired = $isToBeHired;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Percent_Allocation value
     * @return float|null
     */
    public function getPercent_Allocation()
    {
        return $this->Percent_Allocation;
    }
    /**
     * Set Percent_Allocation value
     * @param float $percent_Allocation
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setPercent_Allocation($percent_Allocation = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Allocation) && !(is_float($percent_Allocation) || is_numeric($percent_Allocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Allocation, true), gettype($percent_Allocation)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Allocation) && mb_strlen(mb_substr($percent_Allocation, false !== mb_strpos($percent_Allocation, '.') ? mb_strpos($percent_Allocation, '.') + 1 : mb_strlen($percent_Allocation))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Allocation, true), mb_strlen(mb_substr($percent_Allocation, mb_strpos($percent_Allocation, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Allocation) && $percent_Allocation < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Allocation, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Allocation) && mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Allocation, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation))), __LINE__);
        }
        $this->Percent_Allocation = $percent_Allocation;
        return $this;
    }
    /**
     * Get Estimated_Hours value
     * @return float|null
     */
    public function getEstimated_Hours()
    {
        return $this->Estimated_Hours;
    }
    /**
     * Set Estimated_Hours value
     * @param float $estimated_Hours
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setEstimated_Hours($estimated_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Hours) && !(is_float($estimated_Hours) || is_numeric($estimated_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Hours, true), gettype($estimated_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($estimated_Hours) && mb_strlen(mb_substr($estimated_Hours, false !== mb_strpos($estimated_Hours, '.') ? mb_strpos($estimated_Hours, '.') + 1 : mb_strlen($estimated_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($estimated_Hours, true), mb_strlen(mb_substr($estimated_Hours, mb_strpos($estimated_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Hours) && $estimated_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($estimated_Hours) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($estimated_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours))), __LINE__);
        }
        $this->Estimated_Hours = $estimated_Hours;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Project_Booking_Status_Reference value
     * @return \StructType\Project_Booking_StatusObjectType|null
     */
    public function getProject_Booking_Status_Reference()
    {
        return $this->Project_Booking_Status_Reference;
    }
    /**
     * Set Project_Booking_Status_Reference value
     * @param \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setProject_Booking_Status_Reference(\StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference = null)
    {
        $this->Project_Booking_Status_Reference = $project_Booking_Status_Reference;
        return $this;
    }
    /**
     * Get Worker_Group_Reference value
     * @return \StructType\Project_Member_ResourceObjectType|null
     */
    public function getWorker_Group_Reference()
    {
        return $this->Worker_Group_Reference;
    }
    /**
     * Set Worker_Group_Reference value
     * @param \StructType\Project_Member_ResourceObjectType $worker_Group_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setWorker_Group_Reference(\StructType\Project_Member_ResourceObjectType $worker_Group_Reference = null)
    {
        $this->Worker_Group_Reference = $worker_Group_Reference;
        return $this;
    }
    /**
     * Get Excluded_Workers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getExcluded_Workers_Reference()
    {
        return $this->Excluded_Workers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExcluded_Workers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExcluded_Workers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExcluded_Workers_ReferenceForArrayConstraintsFromSetExcluded_Workers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem) ? get_class($project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem) : sprintf('%s(%s)', gettype($project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem), var_export($project_Resource_Plan_Detail_WWS_DataTypeExcluded_Workers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Excluded_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Excluded_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $excluded_Workers_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setExcluded_Workers_Reference(array $excluded_Workers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($excluded_Workers_ReferenceArrayErrorMessage = self::validateExcluded_Workers_ReferenceForArrayConstraintsFromSetExcluded_Workers_Reference($excluded_Workers_Reference))) {
            throw new \InvalidArgumentException($excluded_Workers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Excluded_Workers_Reference = $excluded_Workers_Reference;
        return $this;
    }
    /**
     * Add item to Excluded_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function addToExcluded_Workers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Excluded_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Excluded_Workers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Standard_Cost_Rate value
     * @return float|null
     */
    public function getStandard_Cost_Rate()
    {
        return $this->Standard_Cost_Rate;
    }
    /**
     * Set Standard_Cost_Rate value
     * @param float $standard_Cost_Rate
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setStandard_Cost_Rate($standard_Cost_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($standard_Cost_Rate) && !(is_float($standard_Cost_Rate) || is_numeric($standard_Cost_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standard_Cost_Rate, true), gettype($standard_Cost_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($standard_Cost_Rate) && mb_strlen(mb_substr($standard_Cost_Rate, false !== mb_strpos($standard_Cost_Rate, '.') ? mb_strpos($standard_Cost_Rate, '.') + 1 : mb_strlen($standard_Cost_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($standard_Cost_Rate, true), mb_strlen(mb_substr($standard_Cost_Rate, mb_strpos($standard_Cost_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($standard_Cost_Rate) && $standard_Cost_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($standard_Cost_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($standard_Cost_Rate) && mb_strlen(preg_replace('/(\D)/', '', $standard_Cost_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($standard_Cost_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $standard_Cost_Rate))), __LINE__);
        }
        $this->Standard_Cost_Rate = $standard_Cost_Rate;
        return $this;
    }
    /**
     * Get Standard_Cost_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getStandard_Cost_Currency_Reference()
    {
        return $this->Standard_Cost_Currency_Reference;
    }
    /**
     * Set Standard_Cost_Currency_Reference value
     * @param \StructType\CurrencyObjectType $standard_Cost_Currency_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setStandard_Cost_Currency_Reference(\StructType\CurrencyObjectType $standard_Cost_Currency_Reference = null)
    {
        $this->Standard_Cost_Currency_Reference = $standard_Cost_Currency_Reference;
        return $this;
    }
    /**
     * Get Contract_Billing_Rate value
     * @return float|null
     */
    public function getContract_Billing_Rate()
    {
        return $this->Contract_Billing_Rate;
    }
    /**
     * Set Contract_Billing_Rate value
     * @param float $contract_Billing_Rate
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setContract_Billing_Rate($contract_Billing_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Billing_Rate) && !(is_float($contract_Billing_Rate) || is_numeric($contract_Billing_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Billing_Rate, true), gettype($contract_Billing_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($contract_Billing_Rate) && mb_strlen(mb_substr($contract_Billing_Rate, false !== mb_strpos($contract_Billing_Rate, '.') ? mb_strpos($contract_Billing_Rate, '.') + 1 : mb_strlen($contract_Billing_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($contract_Billing_Rate, true), mb_strlen(mb_substr($contract_Billing_Rate, mb_strpos($contract_Billing_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($contract_Billing_Rate) && $contract_Billing_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($contract_Billing_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($contract_Billing_Rate) && mb_strlen(preg_replace('/(\D)/', '', $contract_Billing_Rate)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($contract_Billing_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Billing_Rate))), __LINE__);
        }
        $this->Contract_Billing_Rate = $contract_Billing_Rate;
        return $this;
    }
    /**
     * Get Contract_Billing_Rate_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getContract_Billing_Rate_Currency_Reference()
    {
        return $this->Contract_Billing_Rate_Currency_Reference;
    }
    /**
     * Set Contract_Billing_Rate_Currency_Reference value
     * @param \StructType\CurrencyObjectType $contract_Billing_Rate_Currency_Reference
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setContract_Billing_Rate_Currency_Reference(\StructType\CurrencyObjectType $contract_Billing_Rate_Currency_Reference = null)
    {
        $this->Contract_Billing_Rate_Currency_Reference = $contract_Billing_Rate_Currency_Reference;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Resource_Plan_Detail_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
