<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Rate Rule Worker Data
 * @subpackage Structs
 */
class Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Cost Rate Rule Standard Cost Rate Sheet ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Order
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The XMLNAME__Project__Cost_Rate_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Rate Rule
     * @var \StructType\Project_Cost_Rate_RuleObjectType
     */
    public $XMLNAME__Project__Cost_Rate_Rule_Reference;
    /**
     * The Hourly_Rate
     * Meta information extracted from the WSDL
     * - documentation: Project rate rule hourly rate
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Hourly_Rate;
    /**
     * Constructor method for Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     * @uses Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType::setDelete()
     * @uses Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType::setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID()
     * @uses Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType::setOrder()
     * @uses Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType::setXMLNAME__Project__Cost_Rate_Rule_Reference()
     * @uses Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType::setHourly_Rate()
     * @param bool $delete
     * @param string $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID
     * @param string $order
     * @param \StructType\Project_Cost_Rate_RuleObjectType $xMLNAME__Project__Cost_Rate_Rule_Reference
     * @param float $hourly_Rate
     */
    public function __construct($delete = null, $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID = null, $order = null, \StructType\Project_Cost_Rate_RuleObjectType $xMLNAME__Project__Cost_Rate_Rule_Reference = null, $hourly_Rate = null)
    {
        $this
            ->setDelete($delete)
            ->setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID)
            ->setOrder($order)
            ->setXMLNAME__Project__Cost_Rate_Rule_Reference($xMLNAME__Project__Cost_Rate_Rule_Reference)
            ->setHourly_Rate($hourly_Rate);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID value
     * @return string|null
     */
    public function getProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID()
    {
        return $this->Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID;
    }
    /**
     * Set Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID value
     * @param string $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     */
    public function setProject_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID) && !is_string($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID, true), gettype($project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID)), __LINE__);
        }
        $this->Project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID = $project_Cost_Rate_Rule_Standard_Cost_Rate_Detail_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get XMLNAME__Project__Cost_Rate_Rule_Reference value
     * @return \StructType\Project_Cost_Rate_RuleObjectType|null
     */
    public function getXMLNAME__Project__Cost_Rate_Rule_Reference()
    {
        return $this->XMLNAME__Project__Cost_Rate_Rule_Reference;
    }
    /**
     * Set XMLNAME__Project__Cost_Rate_Rule_Reference value
     * @param \StructType\Project_Cost_Rate_RuleObjectType $xMLNAME__Project__Cost_Rate_Rule_Reference
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     */
    public function setXMLNAME__Project__Cost_Rate_Rule_Reference(\StructType\Project_Cost_Rate_RuleObjectType $xMLNAME__Project__Cost_Rate_Rule_Reference = null)
    {
        $this->XMLNAME__Project__Cost_Rate_Rule_Reference = $xMLNAME__Project__Cost_Rate_Rule_Reference;
        return $this;
    }
    /**
     * Get Hourly_Rate value
     * @return float|null
     */
    public function getHourly_Rate()
    {
        return $this->Hourly_Rate;
    }
    /**
     * Set Hourly_Rate value
     * @param float $hourly_Rate
     * @return \StructType\Project_Cost_Rate_Rule_Standard_Cost_Rate_DetailsType
     */
    public function setHourly_Rate($hourly_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($hourly_Rate) && !(is_float($hourly_Rate) || is_numeric($hourly_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hourly_Rate, true), gettype($hourly_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($hourly_Rate) && mb_strlen(mb_substr($hourly_Rate, false !== mb_strpos($hourly_Rate, '.') ? mb_strpos($hourly_Rate, '.') + 1 : mb_strlen($hourly_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($hourly_Rate, true), mb_strlen(mb_substr($hourly_Rate, mb_strpos($hourly_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hourly_Rate) && $hourly_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hourly_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($hourly_Rate) && mb_strlen(preg_replace('/(\D)/', '', $hourly_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($hourly_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $hourly_Rate))), __LINE__);
        }
        $this->Hourly_Rate = $hourly_Rate;
        return $this;
    }
}
