<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_Name_Match_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Credit Card Transaction Name matches for Travel Cities and Merchants.
 * @subpackage Structs
 */
class Credit_Card_Transaction_Name_Match_DataType extends AbstractStructBase
{
    /**
     * The Confidence_Percentage
     * Meta information extracted from the WSDL
     * - documentation: Confidence level percentage of merchant, or travel city names matching Workday's persisted data. | Confidence level percentage must between 0 and 100.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Confidence_Percentage;
    /**
     * The Merchant_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merchant matching the merchant listed on the Credit Card Transaction.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Merchant_Reference;
    /**
     * The Origination_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Origination City matching the origination city on the Credit Card Transaction.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Origination_City_Reference;
    /**
     * The Destination_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Destination City matching the destination city on the Credit Card Transaction.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Destination_City_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Supplier matching the Supplier on the Credit Card Transaction.
     * - minOccurs: 0
     * @var \StructType\Abstract_Payee_Data_NameObjectType
     */
    public $Supplier_Reference;
    /**
     * Constructor method for Credit_Card_Transaction_Name_Match_DataType
     * @uses Credit_Card_Transaction_Name_Match_DataType::setConfidence_Percentage()
     * @uses Credit_Card_Transaction_Name_Match_DataType::setMerchant_Reference()
     * @uses Credit_Card_Transaction_Name_Match_DataType::setOrigination_City_Reference()
     * @uses Credit_Card_Transaction_Name_Match_DataType::setDestination_City_Reference()
     * @uses Credit_Card_Transaction_Name_Match_DataType::setSupplier_Reference()
     * @param float $confidence_Percentage
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     * @param \StructType\Abstract_Spend_Data_NameObjectType $origination_City_Reference
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_City_Reference
     * @param \StructType\Abstract_Payee_Data_NameObjectType $supplier_Reference
     */
    public function __construct($confidence_Percentage = null, \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null, \StructType\Abstract_Spend_Data_NameObjectType $origination_City_Reference = null, \StructType\Abstract_Spend_Data_NameObjectType $destination_City_Reference = null, \StructType\Abstract_Payee_Data_NameObjectType $supplier_Reference = null)
    {
        $this
            ->setConfidence_Percentage($confidence_Percentage)
            ->setMerchant_Reference($merchant_Reference)
            ->setOrigination_City_Reference($origination_City_Reference)
            ->setDestination_City_Reference($destination_City_Reference)
            ->setSupplier_Reference($supplier_Reference);
    }
    /**
     * Get Confidence_Percentage value
     * @return float|null
     */
    public function getConfidence_Percentage()
    {
        return $this->Confidence_Percentage;
    }
    /**
     * Set Confidence_Percentage value
     * @param float $confidence_Percentage
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType
     */
    public function setConfidence_Percentage($confidence_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($confidence_Percentage) && !(is_float($confidence_Percentage) || is_numeric($confidence_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($confidence_Percentage, true), gettype($confidence_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($confidence_Percentage) && mb_strlen(mb_substr($confidence_Percentage, false !== mb_strpos($confidence_Percentage, '.') ? mb_strpos($confidence_Percentage, '.') + 1 : mb_strlen($confidence_Percentage))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($confidence_Percentage, true), mb_strlen(mb_substr($confidence_Percentage, mb_strpos($confidence_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($confidence_Percentage) && $confidence_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($confidence_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($confidence_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $confidence_Percentage)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($confidence_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $confidence_Percentage))), __LINE__);
        }
        $this->Confidence_Percentage = $confidence_Percentage;
        return $this;
    }
    /**
     * Get Merchant_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getMerchant_Reference()
    {
        return $this->Merchant_Reference;
    }
    /**
     * Set Merchant_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType
     */
    public function setMerchant_Reference(\StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null)
    {
        $this->Merchant_Reference = $merchant_Reference;
        return $this;
    }
    /**
     * Get Origination_City_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getOrigination_City_Reference()
    {
        return $this->Origination_City_Reference;
    }
    /**
     * Set Origination_City_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $origination_City_Reference
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType
     */
    public function setOrigination_City_Reference(\StructType\Abstract_Spend_Data_NameObjectType $origination_City_Reference = null)
    {
        $this->Origination_City_Reference = $origination_City_Reference;
        return $this;
    }
    /**
     * Get Destination_City_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getDestination_City_Reference()
    {
        return $this->Destination_City_Reference;
    }
    /**
     * Set Destination_City_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_City_Reference
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType
     */
    public function setDestination_City_Reference(\StructType\Abstract_Spend_Data_NameObjectType $destination_City_Reference = null)
    {
        $this->Destination_City_Reference = $destination_City_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Abstract_Payee_Data_NameObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Abstract_Payee_Data_NameObjectType $supplier_Reference
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType
     */
    public function setSupplier_Reference(\StructType\Abstract_Payee_Data_NameObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
}
