<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjust_Asset_In_Service_Date_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Business Process Parameters, Business Asset Reference for asset to update, and asset in service date update details.
 * @subpackage Structs
 */
class Adjust_Asset_In_Service_Date_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The asset is part of a lease contract. You can't update the in service date for leased assets. | Cannot update in service date for asset. You cannot update in service date for depreciation schedules with posted depreciation. | Cannot
     * update in service date for asset. The Business Asset is out of service. | Cannot update in service date for business asset. Asset status must be In Service or Issued. | This asset has been impaired. Cannot update in service date for for business
     * assets with impairments. | You cannot update in service date for business asset from intercompany transfer. | The Business Asset is a component of a Non-Discrete Composite Asset or Discrete Composite Asset. You cannot update the in service date for
     * components of a Composite Asset. | Cannot update in service date for this asset since the accounting treatment is not depreciable capital. | Cannot update the in service date of asset. This asset has been disposed. | There is a pending event for the
     * asset that should be completed before this asset transaction can be processed. | Reference to the Business Asset for update to In Service Date.
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_In_Service_Date_Update_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Asset in service date update data.
     * @var \StructType\Business_Asset_In_Service_Date_Update_DataType
     */
    public $Business_Asset_In_Service_Date_Update_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Adjust_Asset_In_Service_Date_RequestType
     * @uses Adjust_Asset_In_Service_Date_RequestType::setBusiness_Asset_Reference()
     * @uses Adjust_Asset_In_Service_Date_RequestType::setBusiness_Process_Parameters()
     * @uses Adjust_Asset_In_Service_Date_RequestType::setBusiness_Asset_In_Service_Date_Update_Data()
     * @uses Adjust_Asset_In_Service_Date_RequestType::setVersion()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_Asset_In_Service_Date_Update_DataType $business_Asset_In_Service_Date_Update_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_Asset_In_Service_Date_Update_DataType $business_Asset_In_Service_Date_Update_Data = null, $version = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_In_Service_Date_Update_Data($business_Asset_In_Service_Date_Update_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Adjust_Asset_In_Service_Date_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Adjust_Asset_In_Service_Date_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_In_Service_Date_Update_Data value
     * @return \StructType\Business_Asset_In_Service_Date_Update_DataType|null
     */
    public function getBusiness_Asset_In_Service_Date_Update_Data()
    {
        return $this->Business_Asset_In_Service_Date_Update_Data;
    }
    /**
     * Set Business_Asset_In_Service_Date_Update_Data value
     * @param \StructType\Business_Asset_In_Service_Date_Update_DataType $business_Asset_In_Service_Date_Update_Data
     * @return \StructType\Adjust_Asset_In_Service_Date_RequestType
     */
    public function setBusiness_Asset_In_Service_Date_Update_Data(\StructType\Business_Asset_In_Service_Date_Update_DataType $business_Asset_In_Service_Date_Update_Data = null)
    {
        $this->Business_Asset_In_Service_Date_Update_Data = $business_Asset_In_Service_Date_Update_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Adjust_Asset_In_Service_Date_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
