<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Update_Asset_Useful_Life
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the submit request for asset useful life updates. You may adjust or correct asset useful life using this operation. To adjust, set the Adjust Useful Life boolean to True; to correct as of the asset acquisition date, leave the
     * boolean False. The web service will submit the transaction into the business process.The public Get Resources web service may be used to export current business asset information and obtain references.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Update_Asset_Useful_Life_RequestType $body
     * @return \StructType\Update_Asset_Useful_Life_ResponseType|bool
     */
    public function Update_Asset_Useful_Life(\StructType\Update_Asset_Useful_Life_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Update_Asset_Useful_Life($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Update_Asset_Book_Configuration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will update asset depreciation schedule information for non-primary asset books. Request data includes asset ID and asset book reference which identify a unique asset depreciation schedule. Request data
     * also includes the following data that you can update: accounting treatment, depreciation profile, depreciation convention, depreciation method, depreciation percent, useful life, in service date, bonus depreciation percent, maximum bonus depreciation
     * basis. In addition, the request allows you to load the historical data accumulated depreciation, year to date depreciation, remaining depreciation periods, historical bonus depreciation and depreciation start date.The web service operation Get Asset
     * Depreciation Schedules can be used to export current asset depreciation schedule data that can be changed and loaded back.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Update_Asset_Book_Configuration_RequestRootType $body
     * @return \StructType\Update_Asset_Book_Configuration_ResponseType|bool
     */
    public function Update_Asset_Book_Configuration(\StructType\Update_Asset_Book_Configuration_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Update_Asset_Book_Configuration($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Update_Asset_Book_Configuration_ResponseType|\StructType\Update_Asset_Useful_Life_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
