<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Car_Rental_Agency_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Car Rental Agency, or change 'Add Only' to 'false' to edit the existing Car Rental Agency. | Element containing Car Rental Agency reference for update and all Car Rental Agency data items
 * @subpackage Structs
 */
class Put_Car_Rental_Agency_RequestType extends AbstractStructBase
{
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Reference
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Car_Rental_Agency_Data
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Data
     * @var \StructType\Car_Rental_Agency_DataType
     */
    public $Car_Rental_Agency_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Car_Rental_Agency_RequestType
     * @uses Put_Car_Rental_Agency_RequestType::setCar_Rental_Agency_Reference()
     * @uses Put_Car_Rental_Agency_RequestType::setCar_Rental_Agency_Data()
     * @uses Put_Car_Rental_Agency_RequestType::setAdd_Only()
     * @uses Put_Car_Rental_Agency_RequestType::setVersion()
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @param \StructType\Car_Rental_Agency_DataType $car_Rental_Agency_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null, \StructType\Car_Rental_Agency_DataType $car_Rental_Agency_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setCar_Rental_Agency_Data($car_Rental_Agency_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @return \StructType\Put_Car_Rental_Agency_RequestType
     */
    public function setCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null)
    {
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Data value
     * @return \StructType\Car_Rental_Agency_DataType|null
     */
    public function getCar_Rental_Agency_Data()
    {
        return $this->Car_Rental_Agency_Data;
    }
    /**
     * Set Car_Rental_Agency_Data value
     * @param \StructType\Car_Rental_Agency_DataType $car_Rental_Agency_Data
     * @return \StructType\Put_Car_Rental_Agency_RequestType
     */
    public function setCar_Rental_Agency_Data(\StructType\Car_Rental_Agency_DataType $car_Rental_Agency_Data = null)
    {
        $this->Car_Rental_Agency_Data = $car_Rental_Agency_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Car_Rental_Agency_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Car_Rental_Agency_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
