<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Order-From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Default PO Issue Email. When adding or editing supplier connection with this information, you need to provide either Email Reference or the Email Address.
 * @subpackage Structs
 */
class Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType extends AbstractStructBase
{
    /**
     * The Email_Reference
     * Meta information extracted from the WSDL
     * - documentation: Email Reference
     * - minOccurs: 0
     * @var \StructType\Email_ReferenceObjectType
     */
    public $Email_Reference;
    /**
     * The Email_Address
     * Meta information extracted from the WSDL
     * - documentation: Email Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Address;
    /**
     * Constructor method for
     * Order-From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType
     * @uses Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType::setEmail_Reference()
     * @uses Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType::setEmail_Address()
     * @param \StructType\Email_ReferenceObjectType $email_Reference
     * @param string $email_Address
     */
    public function __construct(\StructType\Email_ReferenceObjectType $email_Reference = null, $email_Address = null)
    {
        $this
            ->setEmail_Reference($email_Reference)
            ->setEmail_Address($email_Address);
    }
    /**
     * Get Email_Reference value
     * @return \StructType\Email_ReferenceObjectType|null
     */
    public function getEmail_Reference()
    {
        return $this->Email_Reference;
    }
    /**
     * Set Email_Reference value
     * @param \StructType\Email_ReferenceObjectType $email_Reference
     * @return \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType
     */
    public function setEmail_Reference(\StructType\Email_ReferenceObjectType $email_Reference = null)
    {
        $this->Email_Reference = $email_Reference;
        return $this;
    }
    /**
     * Get Email_Address value
     * @return string|null
     */
    public function getEmail_Address()
    {
        return $this->Email_Address;
    }
    /**
     * Set Email_Address value
     * @param string $email_Address
     * @return \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType
     */
    public function setEmail_Address($email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address) && !is_string($email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address, true), gettype($email_Address)), __LINE__);
        }
        $this->Email_Address = $email_Address;
        return $this;
    }
}
