<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lease_Details_Amendment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains details specific to Lease Contract Details
 * @subpackage Structs
 */
class Lease_Details_Amendment_DataType extends AbstractStructBase
{
    /**
     * The Additional_Payment
     * Meta information extracted from the WSDL
     * - documentation: When you select the Additional Payment checkbox, we include additional installment to the payment information grid
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Additional_Payment;
    /**
     * The Interest_Rate
     * Meta information extracted from the WSDL
     * - documentation: Alternate Contract Interest Rate for Lease Contract Amendment | Interest Rate (%)
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Interest_Rate;
    /**
     * The Fixed_Payment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Fixed Payment Amount to apply to each installment of the Lease Contract. | Fixed Payment Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Fixed_Payment_Amount;
    /**
     * Constructor method for Lease_Details_Amendment_DataType
     * @uses Lease_Details_Amendment_DataType::setAdditional_Payment()
     * @uses Lease_Details_Amendment_DataType::setInterest_Rate()
     * @uses Lease_Details_Amendment_DataType::setFixed_Payment_Amount()
     * @param bool $additional_Payment
     * @param float $interest_Rate
     * @param float $fixed_Payment_Amount
     */
    public function __construct($additional_Payment = null, $interest_Rate = null, $fixed_Payment_Amount = null)
    {
        $this
            ->setAdditional_Payment($additional_Payment)
            ->setInterest_Rate($interest_Rate)
            ->setFixed_Payment_Amount($fixed_Payment_Amount);
    }
    /**
     * Get Additional_Payment value
     * @return bool|null
     */
    public function getAdditional_Payment()
    {
        return $this->Additional_Payment;
    }
    /**
     * Set Additional_Payment value
     * @param bool $additional_Payment
     * @return \StructType\Lease_Details_Amendment_DataType
     */
    public function setAdditional_Payment($additional_Payment = null)
    {
        // validation for constraint: boolean
        if (!is_null($additional_Payment) && !is_bool($additional_Payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additional_Payment, true), gettype($additional_Payment)), __LINE__);
        }
        $this->Additional_Payment = $additional_Payment;
        return $this;
    }
    /**
     * Get Interest_Rate value
     * @return float|null
     */
    public function getInterest_Rate()
    {
        return $this->Interest_Rate;
    }
    /**
     * Set Interest_Rate value
     * @param float $interest_Rate
     * @return \StructType\Lease_Details_Amendment_DataType
     */
    public function setInterest_Rate($interest_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($interest_Rate) && !(is_float($interest_Rate) || is_numeric($interest_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interest_Rate, true), gettype($interest_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($interest_Rate) && mb_strlen(mb_substr($interest_Rate, false !== mb_strpos($interest_Rate, '.') ? mb_strpos($interest_Rate, '.') + 1 : mb_strlen($interest_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($interest_Rate, true), mb_strlen(mb_substr($interest_Rate, mb_strpos($interest_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($interest_Rate) && $interest_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($interest_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($interest_Rate) && mb_strlen(preg_replace('/(\D)/', '', $interest_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($interest_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $interest_Rate))), __LINE__);
        }
        $this->Interest_Rate = $interest_Rate;
        return $this;
    }
    /**
     * Get Fixed_Payment_Amount value
     * @return float|null
     */
    public function getFixed_Payment_Amount()
    {
        return $this->Fixed_Payment_Amount;
    }
    /**
     * Set Fixed_Payment_Amount value
     * @param float $fixed_Payment_Amount
     * @return \StructType\Lease_Details_Amendment_DataType
     */
    public function setFixed_Payment_Amount($fixed_Payment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($fixed_Payment_Amount) && !(is_float($fixed_Payment_Amount) || is_numeric($fixed_Payment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixed_Payment_Amount, true), gettype($fixed_Payment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($fixed_Payment_Amount) && mb_strlen(mb_substr($fixed_Payment_Amount, false !== mb_strpos($fixed_Payment_Amount, '.') ? mb_strpos($fixed_Payment_Amount, '.') + 1 : mb_strlen($fixed_Payment_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($fixed_Payment_Amount, true), mb_strlen(mb_substr($fixed_Payment_Amount, mb_strpos($fixed_Payment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($fixed_Payment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $fixed_Payment_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($fixed_Payment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $fixed_Payment_Amount))), __LINE__);
        }
        $this->Fixed_Payment_Amount = $fixed_Payment_Amount;
        return $this;
    }
}
