<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Asset_Book_Restriction_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request references for the company asset book restrictions operation
 * @subpackage Structs
 */
class Company_Asset_Book_Restriction_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company references for company asset book restrictions
     * - maxOccurs: unbounded
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * Constructor method for Company_Asset_Book_Restriction_Request_ReferencesType
     * @uses Company_Asset_Book_Restriction_Request_ReferencesType::setCompany_Reference()
     * @param \StructType\CompanyObjectType[] $company_Reference
     */
    public function __construct(array $company_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem), var_export($company_Asset_Book_Restriction_Request_ReferencesTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Request_ReferencesType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Request_ReferencesType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
}
