<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_ScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the Asset Depreciation Schedule reference and data.
 * @subpackage Structs
 */
class Asset_Depreciation_ScheduleType extends AbstractStructBase
{
    /**
     * The Asset_Book_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the asset book configuration
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Asset_Book_Configuration_Reference;
    /**
     * The Asset_Book_Configuration_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_Schedule_DataType[]
     */
    public $Asset_Book_Configuration_Data;
    /**
     * Constructor method for Asset_Depreciation_ScheduleType
     * @uses Asset_Depreciation_ScheduleType::setAsset_Book_Configuration_Reference()
     * @uses Asset_Depreciation_ScheduleType::setAsset_Book_Configuration_Data()
     * @param \StructType\Unique_IdentifierObjectType $asset_Book_Configuration_Reference
     * @param \StructType\Asset_Depreciation_Schedule_DataType[] $asset_Book_Configuration_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $asset_Book_Configuration_Reference = null, array $asset_Book_Configuration_Data = array())
    {
        $this
            ->setAsset_Book_Configuration_Reference($asset_Book_Configuration_Reference)
            ->setAsset_Book_Configuration_Data($asset_Book_Configuration_Data);
    }
    /**
     * Get Asset_Book_Configuration_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getAsset_Book_Configuration_Reference()
    {
        return $this->Asset_Book_Configuration_Reference;
    }
    /**
     * Set Asset_Book_Configuration_Reference value
     * @param \StructType\Unique_IdentifierObjectType $asset_Book_Configuration_Reference
     * @return \StructType\Asset_Depreciation_ScheduleType
     */
    public function setAsset_Book_Configuration_Reference(\StructType\Unique_IdentifierObjectType $asset_Book_Configuration_Reference = null)
    {
        $this->Asset_Book_Configuration_Reference = $asset_Book_Configuration_Reference;
        return $this;
    }
    /**
     * Get Asset_Book_Configuration_Data value
     * @return \StructType\Asset_Depreciation_Schedule_DataType[]|null
     */
    public function getAsset_Book_Configuration_Data()
    {
        return $this->Asset_Book_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_Configuration_DataForArrayConstraintsFromSetAsset_Book_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem instanceof \StructType\Asset_Depreciation_Schedule_DataType) {
                $invalidValues[] = is_object($asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem) ? get_class($asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem) : sprintf('%s(%s)', gettype($asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem), var_export($asset_Depreciation_ScheduleTypeAsset_Book_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Configuration_Data property can only contain items of type \StructType\Asset_Depreciation_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Schedule_DataType[] $asset_Book_Configuration_Data
     * @return \StructType\Asset_Depreciation_ScheduleType
     */
    public function setAsset_Book_Configuration_Data(array $asset_Book_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_Configuration_DataArrayErrorMessage = self::validateAsset_Book_Configuration_DataForArrayConstraintsFromSetAsset_Book_Configuration_Data($asset_Book_Configuration_Data))) {
            throw new \InvalidArgumentException($asset_Book_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Configuration_Data = $asset_Book_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Asset_Book_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Schedule_DataType $item
     * @return \StructType\Asset_Depreciation_ScheduleType
     */
    public function addToAsset_Book_Configuration_Data(\StructType\Asset_Depreciation_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Depreciation_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Configuration_Data property can only contain items of type \StructType\Asset_Depreciation_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Configuration_Data[] = $item;
        return $this;
    }
}
