<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Card_Transaction_Verification_Summary_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't enter a Supplier Contract that has an End Date before the Transaction Date of the procurement card transaction verification. | You can't associate a procurement card verification to purchase orders of the type Consignment
 * or Bill and Replace. | You can't associate a procurement card verification to supplier contracts of the type Consignment. | Element containing Procurement Card Transaction Verification Summary Data.
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_Summary_DataType extends AbstractStructBase
{
    /**
     * The Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Transaction Reference
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Credit_Card_Transaction_Reference;
    /**
     * The Transaction_Date
     * Meta information extracted from the WSDL
     * - documentation: Transaction DateThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Date;
    /**
     * The Charge_Description
     * Meta information extracted from the WSDL
     * - documentation: Charge DescriptionThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Description;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Transaction_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Transaction Source CurrencyThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Transaction_Currency_Reference;
    /**
     * The Sales_Tax_Collected
     * Meta information extracted from the WSDL
     * - documentation: Shows whether Sales Taxes were collected.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Sales_Tax_Collected;
    /**
     * The Financial_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Financial Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Financial_Attachment_Data;
    /**
     * The Procurement_Card_Transaction_Verification_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Procurement Card Transaction Verification Line Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_Verification_Line_DataType[]
     */
    public $Procurement_Card_Transaction_Verification_Line_Data;
    /**
     * Constructor method for
     * Procurement_Card_Transaction_Verification_Summary_DataType
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setCredit_Card_Transaction_Reference()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setTransaction_Date()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setCharge_Description()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setSupplier_Reference()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setPurchase_Order_Reference()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setSupplier_Contract_Reference()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setExtended_Amount()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setTransaction_Currency_Reference()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setSales_Tax_Collected()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setFinancial_Attachment_Data()
     * @uses Procurement_Card_Transaction_Verification_Summary_DataType::setProcurement_Card_Transaction_Verification_Line_Data()
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @param string $transaction_Date
     * @param string $charge_Description
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param float $extended_Amount
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @param bool $sales_Tax_Collected
     * @param \StructType\Financials_Attachment_DataType[] $financial_Attachment_Data
     * @param \StructType\Procurement_Card_Transaction_Verification_Line_DataType[] $procurement_Card_Transaction_Verification_Line_Data
     */
    public function __construct(\StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null, $transaction_Date = null, $charge_Description = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, $extended_Amount = null, \StructType\CurrencyObjectType $transaction_Currency_Reference = null, $sales_Tax_Collected = null, array $financial_Attachment_Data = array(), array $procurement_Card_Transaction_Verification_Line_Data = array())
    {
        $this
            ->setCredit_Card_Transaction_Reference($credit_Card_Transaction_Reference)
            ->setTransaction_Date($transaction_Date)
            ->setCharge_Description($charge_Description)
            ->setSupplier_Reference($supplier_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setExtended_Amount($extended_Amount)
            ->setTransaction_Currency_Reference($transaction_Currency_Reference)
            ->setSales_Tax_Collected($sales_Tax_Collected)
            ->setFinancial_Attachment_Data($financial_Attachment_Data)
            ->setProcurement_Card_Transaction_Verification_Line_Data($procurement_Card_Transaction_Verification_Line_Data);
    }
    /**
     * Get Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getCredit_Card_Transaction_Reference()
    {
        return $this->Credit_Card_Transaction_Reference;
    }
    /**
     * Set Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setCredit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null)
    {
        $this->Credit_Card_Transaction_Reference = $credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Transaction_Date value
     * @return string|null
     */
    public function getTransaction_Date()
    {
        return $this->Transaction_Date;
    }
    /**
     * Set Transaction_Date value
     * @param string $transaction_Date
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setTransaction_Date($transaction_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Date) && !is_string($transaction_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Date, true), gettype($transaction_Date)), __LINE__);
        }
        $this->Transaction_Date = $transaction_Date;
        return $this;
    }
    /**
     * Get Charge_Description value
     * @return string|null
     */
    public function getCharge_Description()
    {
        return $this->Charge_Description;
    }
    /**
     * Set Charge_Description value
     * @param string $charge_Description
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setCharge_Description($charge_Description = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Description) && !is_string($charge_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Description, true), gettype($charge_Description)), __LINE__);
        }
        $this->Charge_Description = $charge_Description;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Transaction_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getTransaction_Currency_Reference()
    {
        return $this->Transaction_Currency_Reference;
    }
    /**
     * Set Transaction_Currency_Reference value
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setTransaction_Currency_Reference(\StructType\CurrencyObjectType $transaction_Currency_Reference = null)
    {
        $this->Transaction_Currency_Reference = $transaction_Currency_Reference;
        return $this;
    }
    /**
     * Get Sales_Tax_Collected value
     * @return bool|null
     */
    public function getSales_Tax_Collected()
    {
        return $this->Sales_Tax_Collected;
    }
    /**
     * Set Sales_Tax_Collected value
     * @param bool $sales_Tax_Collected
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setSales_Tax_Collected($sales_Tax_Collected = null)
    {
        // validation for constraint: boolean
        if (!is_null($sales_Tax_Collected) && !is_bool($sales_Tax_Collected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sales_Tax_Collected, true), gettype($sales_Tax_Collected)), __LINE__);
        }
        $this->Sales_Tax_Collected = $sales_Tax_Collected;
        return $this;
    }
    /**
     * Get Financial_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getFinancial_Attachment_Data()
    {
        return $this->Financial_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancial_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancial_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancial_Attachment_DataForArrayConstraintsFromSetFinancial_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem) ? get_class($procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem), var_export($procurement_Card_Transaction_Verification_Summary_DataTypeFinancial_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Financial_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Financial_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $financial_Attachment_Data
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setFinancial_Attachment_Data(array $financial_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($financial_Attachment_DataArrayErrorMessage = self::validateFinancial_Attachment_DataForArrayConstraintsFromSetFinancial_Attachment_Data($financial_Attachment_Data))) {
            throw new \InvalidArgumentException($financial_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Financial_Attachment_Data = $financial_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Financial_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function addToFinancial_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Financial_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Financial_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Line_Data value
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType[]|null
     */
    public function getProcurement_Card_Transaction_Verification_Line_Data()
    {
        return $this->Procurement_Card_Transaction_Verification_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Card_Transaction_Verification_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Card_Transaction_Verification_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Card_Transaction_Verification_Line_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem instanceof \StructType\Procurement_Card_Transaction_Verification_Line_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem) ? get_class($procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem), var_export($procurement_Card_Transaction_Verification_Summary_DataTypeProcurement_Card_Transaction_Verification_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Card_Transaction_Verification_Line_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_Line_DataType[] $procurement_Card_Transaction_Verification_Line_Data
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function setProcurement_Card_Transaction_Verification_Line_Data(array $procurement_Card_Transaction_Verification_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Card_Transaction_Verification_Line_DataArrayErrorMessage = self::validateProcurement_Card_Transaction_Verification_Line_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Line_Data($procurement_Card_Transaction_Verification_Line_Data))) {
            throw new \InvalidArgumentException($procurement_Card_Transaction_Verification_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Line_Data = $procurement_Card_Transaction_Verification_Line_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Card_Transaction_Verification_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_Line_DataType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType
     */
    public function addToProcurement_Card_Transaction_Verification_Line_Data(\StructType\Procurement_Card_Transaction_Verification_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Card_Transaction_Verification_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Card_Transaction_Verification_Line_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Line_Data[] = $item;
        return $this;
    }
}
