<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Default_PO_Issue_Email_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Order Issue Email Replacement Data allows the user to supply a set of purchase order issue emails to replace those on the Purchase Order Change Order. If this element is supplied but no emails are set then the purchase order
 * issue emails are cleared. If this element is omitted then no change is made to the purchase order issue emails.
 * @subpackage Structs
 */
class Default_PO_Issue_Email_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Issue_Email_Data
     * Meta information extracted from the WSDL
     * - documentation: Default PO Issue Email Data allows the user to select emails specified on Purchase Order Issue Email Data to be used as the default Issue Email address on all Purchase Orders.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Default_PO_Issue_Email_DataType[]
     */
    public $Purchase_Order_Issue_Email_Data;
    /**
     * Constructor method for Default_PO_Issue_Email_Replacement_DataType
     * @uses Default_PO_Issue_Email_Replacement_DataType::setPurchase_Order_Issue_Email_Data()
     * @param \StructType\Default_PO_Issue_Email_DataType[] $purchase_Order_Issue_Email_Data
     */
    public function __construct(array $purchase_Order_Issue_Email_Data = array())
    {
        $this
            ->setPurchase_Order_Issue_Email_Data($purchase_Order_Issue_Email_Data);
    }
    /**
     * Get Purchase_Order_Issue_Email_Data value
     * @return \StructType\Default_PO_Issue_Email_DataType[]|null
     */
    public function getPurchase_Order_Issue_Email_Data()
    {
        return $this->Purchase_Order_Issue_Email_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Issue_Email_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Issue_Email_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Issue_Email_DataForArrayConstraintsFromSetPurchase_Order_Issue_Email_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem) {
            // validation for constraint: itemType
            if (!$default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem instanceof \StructType\Default_PO_Issue_Email_DataType) {
                $invalidValues[] = is_object($default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem) ? get_class($default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem) : sprintf('%s(%s)', gettype($default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem), var_export($default_PO_Issue_Email_Replacement_DataTypePurchase_Order_Issue_Email_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Issue_Email_Data property can only contain items of type \StructType\Default_PO_Issue_Email_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Issue_Email_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Default_PO_Issue_Email_DataType[] $purchase_Order_Issue_Email_Data
     * @return \StructType\Default_PO_Issue_Email_Replacement_DataType
     */
    public function setPurchase_Order_Issue_Email_Data(array $purchase_Order_Issue_Email_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Issue_Email_DataArrayErrorMessage = self::validatePurchase_Order_Issue_Email_DataForArrayConstraintsFromSetPurchase_Order_Issue_Email_Data($purchase_Order_Issue_Email_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Issue_Email_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Issue_Email_Data = $purchase_Order_Issue_Email_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Issue_Email_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Default_PO_Issue_Email_DataType $item
     * @return \StructType\Default_PO_Issue_Email_Replacement_DataType
     */
    public function addToPurchase_Order_Issue_Email_Data(\StructType\Default_PO_Issue_Email_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Default_PO_Issue_Email_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Issue_Email_Data property can only contain items of type \StructType\Default_PO_Issue_Email_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Issue_Email_Data[] = $item;
        return $this;
    }
}
