<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Child_Project_Data_for_PortfolioType StructType
 * Meta information extracted from the WSDL
 * - documentation: Child Project Data for Portfolio
 * @subpackage Structs
 */
class Child_Project_Data_for_PortfolioType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: The direct child project of the project portfolio
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Funding_Amount
     * Meta information extracted from the WSDL
     * - documentation: The funding amount allocated to the project in the currency of the parent project portfolio. This can only be updated by users with access to the project portfolio through the Manage: Project Portfolio Funding domain.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Project_Funding_Amount;
    /**
     * The Project_Funding_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The funding status of the project from the parent project portfolio. This can only be updated by users with access to the project portfolio through the Manage: Project Portfolio Funding domain.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Project_Funding_Status_Reference;
    /**
     * Constructor method for Child_Project_Data_for_PortfolioType
     * @uses Child_Project_Data_for_PortfolioType::setProject_Reference()
     * @uses Child_Project_Data_for_PortfolioType::setProject_Funding_Amount()
     * @uses Child_Project_Data_for_PortfolioType::setProject_Funding_Status_Reference()
     * @param \StructType\ProjectObjectType $project_Reference
     * @param float $project_Funding_Amount
     * @param \StructType\Document_StatusObjectType $project_Funding_Status_Reference
     */
    public function __construct(\StructType\ProjectObjectType $project_Reference = null, $project_Funding_Amount = null, \StructType\Document_StatusObjectType $project_Funding_Status_Reference = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setProject_Funding_Amount($project_Funding_Amount)
            ->setProject_Funding_Status_Reference($project_Funding_Status_Reference);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Child_Project_Data_for_PortfolioType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Funding_Amount value
     * @return float|null
     */
    public function getProject_Funding_Amount()
    {
        return $this->Project_Funding_Amount;
    }
    /**
     * Set Project_Funding_Amount value
     * @param float $project_Funding_Amount
     * @return \StructType\Child_Project_Data_for_PortfolioType
     */
    public function setProject_Funding_Amount($project_Funding_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($project_Funding_Amount) && !(is_float($project_Funding_Amount) || is_numeric($project_Funding_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($project_Funding_Amount, true), gettype($project_Funding_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($project_Funding_Amount) && mb_strlen(mb_substr($project_Funding_Amount, false !== mb_strpos($project_Funding_Amount, '.') ? mb_strpos($project_Funding_Amount, '.') + 1 : mb_strlen($project_Funding_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($project_Funding_Amount, true), mb_strlen(mb_substr($project_Funding_Amount, mb_strpos($project_Funding_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($project_Funding_Amount) && $project_Funding_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($project_Funding_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($project_Funding_Amount) && mb_strlen(preg_replace('/(\D)/', '', $project_Funding_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($project_Funding_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $project_Funding_Amount))), __LINE__);
        }
        $this->Project_Funding_Amount = $project_Funding_Amount;
        return $this;
    }
    /**
     * Get Project_Funding_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getProject_Funding_Status_Reference()
    {
        return $this->Project_Funding_Status_Reference;
    }
    /**
     * Set Project_Funding_Status_Reference value
     * @param \StructType\Document_StatusObjectType $project_Funding_Status_Reference
     * @return \StructType\Child_Project_Data_for_PortfolioType
     */
    public function setProject_Funding_Status_Reference(\StructType\Document_StatusObjectType $project_Funding_Status_Reference = null)
    {
        $this->Project_Funding_Status_Reference = $project_Funding_Status_Reference;
        return $this;
    }
}
