<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Order_Contract_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Order Contract is not in draft status and cannot be submitted. | The Web Service is set to Add Only; documents cannot be resubmitted. This may happen if you have a Contract ID field that conflicts with an existing Contract,
 * or if you have both the Add Only flag on and pass in a Supplier Order Contract Reference. | Element encapsulating Submit Supplier Contract Request
 * @subpackage Structs
 */
class Submit_Supplier_Order_Contract_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Order_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Order_Contract_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Order_Contract_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract Data
     * - minOccurs: 0
     * @var \StructType\Supplier_Order_Contract_DataType
     */
    public $Supplier_Order_Contract_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Order_Contract_RequestType
     * @uses Submit_Supplier_Order_Contract_RequestType::setSupplier_Order_Contract_Reference()
     * @uses Submit_Supplier_Order_Contract_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Order_Contract_RequestType::setSupplier_Order_Contract_Data()
     * @uses Submit_Supplier_Order_Contract_RequestType::setAdd_Only()
     * @uses Submit_Supplier_Order_Contract_RequestType::setVersion()
     * @param \StructType\Supplier_ContractObjectType $supplier_Order_Contract_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Order_Contract_DataType $supplier_Order_Contract_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Order_Contract_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Order_Contract_DataType $supplier_Order_Contract_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Order_Contract_Reference($supplier_Order_Contract_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Order_Contract_Data($supplier_Order_Contract_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Order_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Order_Contract_Reference()
    {
        return $this->Supplier_Order_Contract_Reference;
    }
    /**
     * Set Supplier_Order_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Order_Contract_Reference
     * @return \StructType\Submit_Supplier_Order_Contract_RequestType
     */
    public function setSupplier_Order_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Order_Contract_Reference = null)
    {
        $this->Supplier_Order_Contract_Reference = $supplier_Order_Contract_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Order_Contract_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Order_Contract_Data value
     * @return \StructType\Supplier_Order_Contract_DataType|null
     */
    public function getSupplier_Order_Contract_Data()
    {
        return $this->Supplier_Order_Contract_Data;
    }
    /**
     * Set Supplier_Order_Contract_Data value
     * @param \StructType\Supplier_Order_Contract_DataType $supplier_Order_Contract_Data
     * @return \StructType\Submit_Supplier_Order_Contract_RequestType
     */
    public function setSupplier_Order_Contract_Data(\StructType\Supplier_Order_Contract_DataType $supplier_Order_Contract_Data = null)
    {
        $this->Supplier_Order_Contract_Data = $supplier_Order_Contract_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_Order_Contract_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Order_Contract_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
