<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Template_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each resource plan template based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Resource_Plan_Template_Response_DataType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Template
     * Meta information extracted from the WSDL
     * - documentation: Contains all resource plan template references and data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_TemplateType[]
     */
    public $Resource_Plan_Template;
    /**
     * Constructor method for Resource_Plan_Template_Response_DataType
     * @uses Resource_Plan_Template_Response_DataType::setResource_Plan_Template()
     * @param \StructType\Resource_Plan_TemplateType[] $resource_Plan_Template
     */
    public function __construct(array $resource_Plan_Template = array())
    {
        $this
            ->setResource_Plan_Template($resource_Plan_Template);
    }
    /**
     * Get Resource_Plan_Template value
     * @return \StructType\Resource_Plan_TemplateType[]|null
     */
    public function getResource_Plan_Template()
    {
        return $this->Resource_Plan_Template;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Plan_Template method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Plan_Template method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Plan_TemplateForArrayConstraintsFromSetResource_Plan_Template(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem instanceof \StructType\Resource_Plan_TemplateType) {
                $invalidValues[] = is_object($resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem) ? get_class($resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem) : sprintf('%s(%s)', gettype($resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem), var_export($resource_Plan_Template_Response_DataTypeResource_Plan_TemplateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Plan_Template property can only contain items of type \StructType\Resource_Plan_TemplateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Plan_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_TemplateType[] $resource_Plan_Template
     * @return \StructType\Resource_Plan_Template_Response_DataType
     */
    public function setResource_Plan_Template(array $resource_Plan_Template = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Plan_TemplateArrayErrorMessage = self::validateResource_Plan_TemplateForArrayConstraintsFromSetResource_Plan_Template($resource_Plan_Template))) {
            throw new \InvalidArgumentException($resource_Plan_TemplateArrayErrorMessage, __LINE__);
        }
        $this->Resource_Plan_Template = $resource_Plan_Template;
        return $this;
    }
    /**
     * Add item to Resource_Plan_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_TemplateType $item
     * @return \StructType\Resource_Plan_Template_Response_DataType
     */
    public function addToResource_Plan_Template(\StructType\Resource_Plan_TemplateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Plan_TemplateType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Plan_Template property can only contain items of type \StructType\Resource_Plan_TemplateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Plan_Template[] = $item;
        return $this;
    }
}
