<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reinstate_Asset_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A wrapper element containing the data about the asset reinstatement.
 * @subpackage Structs
 */
class Reinstate_Asset_WWS_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the asset that should be reinstated.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: An optional comment to track with the asset reinstatement event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Reinstate_Asset_WWS_DataType
     * @uses Reinstate_Asset_WWS_DataType::setAsset_Reference()
     * @uses Reinstate_Asset_WWS_DataType::setComment()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $comment
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $comment = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setComment($comment);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Reinstate_Asset_WWS_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Reinstate_Asset_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
