<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: To save changes to the configuration fields, enable manual web service load for tax certificate numbers for supplier invoice payments. | Put Withholding Tax Certificate Numbers On Supplier Payment Request
 * @subpackage Structs
 */
class Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Payment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Payment
     * @var \StructType\Supplier_Payment_for_InvoicesObjectType
     */
    public $Supplier_Payment_Reference;
    /**
     * The Supplier_Payment_Tax_Certificate_Manual_Numbers_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Payment Withholding Tax Certificate Manual Numbers Data
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType[]
     */
    public $Supplier_Payment_Tax_Certificate_Manual_Numbers_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for
     * Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType
     * @uses Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType::setSupplier_Payment_Reference()
     * @uses Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType::setSupplier_Payment_Tax_Certificate_Manual_Numbers_Data()
     * @uses Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType::setVersion()
     * @param \StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference
     * @param \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType[] $supplier_Payment_Tax_Certificate_Manual_Numbers_Data
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference = null, array $supplier_Payment_Tax_Certificate_Manual_Numbers_Data = array(), $version = null)
    {
        $this
            ->setSupplier_Payment_Reference($supplier_Payment_Reference)
            ->setSupplier_Payment_Tax_Certificate_Manual_Numbers_Data($supplier_Payment_Tax_Certificate_Manual_Numbers_Data)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Payment_Reference value
     * @return \StructType\Supplier_Payment_for_InvoicesObjectType|null
     */
    public function getSupplier_Payment_Reference()
    {
        return $this->Supplier_Payment_Reference;
    }
    /**
     * Set Supplier_Payment_Reference value
     * @param \StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference
     * @return \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType
     */
    public function setSupplier_Payment_Reference(\StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference = null)
    {
        $this->Supplier_Payment_Reference = $supplier_Payment_Reference;
        return $this;
    }
    /**
     * Get Supplier_Payment_Tax_Certificate_Manual_Numbers_Data value
     * @return \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType[]|null
     */
    public function getSupplier_Payment_Tax_Certificate_Manual_Numbers_Data()
    {
        return $this->Supplier_Payment_Tax_Certificate_Manual_Numbers_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Payment_Tax_Certificate_Manual_Numbers_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Payment_Tax_Certificate_Manual_Numbers_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Payment_Tax_Certificate_Manual_Numbers_DataForArrayConstraintsFromSetSupplier_Payment_Tax_Certificate_Manual_Numbers_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem) {
            // validation for constraint: itemType
            if (!$put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem instanceof \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType) {
                $invalidValues[] = is_object($put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem) ? get_class($put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem) : sprintf('%s(%s)', gettype($put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem), var_export($put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestTypeSupplier_Payment_Tax_Certificate_Manual_Numbers_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Payment_Tax_Certificate_Manual_Numbers_Data property can only contain items of type \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Payment_Tax_Certificate_Manual_Numbers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType[] $supplier_Payment_Tax_Certificate_Manual_Numbers_Data
     * @return \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType
     */
    public function setSupplier_Payment_Tax_Certificate_Manual_Numbers_Data(array $supplier_Payment_Tax_Certificate_Manual_Numbers_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Payment_Tax_Certificate_Manual_Numbers_DataArrayErrorMessage = self::validateSupplier_Payment_Tax_Certificate_Manual_Numbers_DataForArrayConstraintsFromSetSupplier_Payment_Tax_Certificate_Manual_Numbers_Data($supplier_Payment_Tax_Certificate_Manual_Numbers_Data))) {
            throw new \InvalidArgumentException($supplier_Payment_Tax_Certificate_Manual_Numbers_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Payment_Tax_Certificate_Manual_Numbers_Data = $supplier_Payment_Tax_Certificate_Manual_Numbers_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Payment_Tax_Certificate_Manual_Numbers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType $item
     * @return \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType
     */
    public function addToSupplier_Payment_Tax_Certificate_Manual_Numbers_Data(\StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Payment_Tax_Certificate_Manual_Numbers_Data property can only contain items of type \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Payment_Tax_Certificate_Manual_Numbers_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
