<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Role_Category_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Role Category reference for update and all Project Role Category data
 * @subpackage Structs
 */
class Put_Project_Role_Category_RequestType extends AbstractStructBase
{
    /**
     * The Project_Role_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Project Role Category
     * - minOccurs: 0
     * @var \StructType\Project_Role_CategoryObjectType
     */
    public $Project_Role_Category_Reference;
    /**
     * The Project_Role_Category_Data
     * @var \StructType\Project_Role_Category_DataType
     */
    public $Project_Role_Category_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Boolean for Project Role Category
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Role_Category_RequestType
     * @uses Put_Project_Role_Category_RequestType::setProject_Role_Category_Reference()
     * @uses Put_Project_Role_Category_RequestType::setProject_Role_Category_Data()
     * @uses Put_Project_Role_Category_RequestType::setAdd_Only()
     * @uses Put_Project_Role_Category_RequestType::setVersion()
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @param \StructType\Project_Role_Category_DataType $project_Role_Category_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null, \StructType\Project_Role_Category_DataType $project_Role_Category_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Role_Category_Reference($project_Role_Category_Reference)
            ->setProject_Role_Category_Data($project_Role_Category_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Role_Category_Reference value
     * @return \StructType\Project_Role_CategoryObjectType|null
     */
    public function getProject_Role_Category_Reference()
    {
        return $this->Project_Role_Category_Reference;
    }
    /**
     * Set Project_Role_Category_Reference value
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @return \StructType\Put_Project_Role_Category_RequestType
     */
    public function setProject_Role_Category_Reference(\StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null)
    {
        $this->Project_Role_Category_Reference = $project_Role_Category_Reference;
        return $this;
    }
    /**
     * Get Project_Role_Category_Data value
     * @return \StructType\Project_Role_Category_DataType|null
     */
    public function getProject_Role_Category_Data()
    {
        return $this->Project_Role_Category_Data;
    }
    /**
     * Set Project_Role_Category_Data value
     * @param \StructType\Project_Role_Category_DataType $project_Role_Category_Data
     * @return \StructType\Put_Project_Role_Category_RequestType
     */
    public function setProject_Role_Category_Data(\StructType\Project_Role_Category_DataType $project_Role_Category_Data = null)
    {
        $this->Project_Role_Category_Data = $project_Role_Category_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Role_Category_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Role_Category_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
