<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Location_Customer_Account_Number_Detail_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture Location Customer Account Number Detail data.
 * @subpackage Structs
 */
class Put_Location_Customer_Account_Number_Detail_RequestType extends AbstractStructBase
{
    /**
     * The Location_Customer_Account_Number_Detail_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location Customer Account Number Detail.
     * - minOccurs: 0
     * @var \StructType\Location_Customer_Account_Number_DetailObjectType
     */
    public $Location_Customer_Account_Number_Detail_Reference;
    /**
     * The Location_Customer_Account_Number_Detail_Data
     * @var \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public $Location_Customer_Account_Number_Detail_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Location_Customer_Account_Number_Detail_RequestType
     * @uses Put_Location_Customer_Account_Number_Detail_RequestType::setLocation_Customer_Account_Number_Detail_Reference()
     * @uses Put_Location_Customer_Account_Number_Detail_RequestType::setLocation_Customer_Account_Number_Detail_Data()
     * @uses Put_Location_Customer_Account_Number_Detail_RequestType::setAdd_Only()
     * @uses Put_Location_Customer_Account_Number_Detail_RequestType::setVersion()
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference
     * @param \StructType\Location_Customer_Account_Number_Detail_DataType $location_Customer_Account_Number_Detail_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference = null, \StructType\Location_Customer_Account_Number_Detail_DataType $location_Customer_Account_Number_Detail_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setLocation_Customer_Account_Number_Detail_Reference($location_Customer_Account_Number_Detail_Reference)
            ->setLocation_Customer_Account_Number_Detail_Data($location_Customer_Account_Number_Detail_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Location_Customer_Account_Number_Detail_Reference value
     * @return \StructType\Location_Customer_Account_Number_DetailObjectType|null
     */
    public function getLocation_Customer_Account_Number_Detail_Reference()
    {
        return $this->Location_Customer_Account_Number_Detail_Reference;
    }
    /**
     * Set Location_Customer_Account_Number_Detail_Reference value
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference
     * @return \StructType\Put_Location_Customer_Account_Number_Detail_RequestType
     */
    public function setLocation_Customer_Account_Number_Detail_Reference(\StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference = null)
    {
        $this->Location_Customer_Account_Number_Detail_Reference = $location_Customer_Account_Number_Detail_Reference;
        return $this;
    }
    /**
     * Get Location_Customer_Account_Number_Detail_Data value
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType|null
     */
    public function getLocation_Customer_Account_Number_Detail_Data()
    {
        return $this->Location_Customer_Account_Number_Detail_Data;
    }
    /**
     * Set Location_Customer_Account_Number_Detail_Data value
     * @param \StructType\Location_Customer_Account_Number_Detail_DataType $location_Customer_Account_Number_Detail_Data
     * @return \StructType\Put_Location_Customer_Account_Number_Detail_RequestType
     */
    public function setLocation_Customer_Account_Number_Detail_Data(\StructType\Location_Customer_Account_Number_Detail_DataType $location_Customer_Account_Number_Detail_Data = null)
    {
        $this->Location_Customer_Account_Number_Detail_Data = $location_Customer_Account_Number_Detail_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Location_Customer_Account_Number_Detail_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Location_Customer_Account_Number_Detail_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
