<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Asset_Pooling_Rule_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Response on the Put operation.
 * @subpackage Structs
 */
class Put_Asset_Pooling_Rule_ResponseType extends AbstractStructBase
{
    /**
     * The Asset_Pooling_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to all Asset Pooling Rules
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Pooling_RuleObjectType[]
     */
    public $Asset_Pooling_Rule_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Asset_Pooling_Rule_ResponseType
     * @uses Put_Asset_Pooling_Rule_ResponseType::setAsset_Pooling_Rule_Reference()
     * @uses Put_Asset_Pooling_Rule_ResponseType::setVersion()
     * @param \StructType\Asset_Pooling_RuleObjectType[] $asset_Pooling_Rule_Reference
     * @param string $version
     */
    public function __construct(array $asset_Pooling_Rule_Reference = array(), $version = null)
    {
        $this
            ->setAsset_Pooling_Rule_Reference($asset_Pooling_Rule_Reference)
            ->setVersion($version);
    }
    /**
     * Get Asset_Pooling_Rule_Reference value
     * @return \StructType\Asset_Pooling_RuleObjectType[]|null
     */
    public function getAsset_Pooling_Rule_Reference()
    {
        return $this->Asset_Pooling_Rule_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Pooling_Rule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Pooling_Rule_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Pooling_Rule_ReferenceForArrayConstraintsFromSetAsset_Pooling_Rule_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem) {
            // validation for constraint: itemType
            if (!$put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem instanceof \StructType\Asset_Pooling_RuleObjectType) {
                $invalidValues[] = is_object($put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem) ? get_class($put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem) : sprintf('%s(%s)', gettype($put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem), var_export($put_Asset_Pooling_Rule_ResponseTypeAsset_Pooling_Rule_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Pooling_Rule_Reference property can only contain items of type \StructType\Asset_Pooling_RuleObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Pooling_Rule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Pooling_RuleObjectType[] $asset_Pooling_Rule_Reference
     * @return \StructType\Put_Asset_Pooling_Rule_ResponseType
     */
    public function setAsset_Pooling_Rule_Reference(array $asset_Pooling_Rule_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Pooling_Rule_ReferenceArrayErrorMessage = self::validateAsset_Pooling_Rule_ReferenceForArrayConstraintsFromSetAsset_Pooling_Rule_Reference($asset_Pooling_Rule_Reference))) {
            throw new \InvalidArgumentException($asset_Pooling_Rule_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Pooling_Rule_Reference = $asset_Pooling_Rule_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Pooling_Rule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Pooling_RuleObjectType $item
     * @return \StructType\Put_Asset_Pooling_Rule_ResponseType
     */
    public function addToAsset_Pooling_Rule_Reference(\StructType\Asset_Pooling_RuleObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Pooling_RuleObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Pooling_Rule_Reference property can only contain items of type \StructType\Asset_Pooling_RuleObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Pooling_Rule_Reference[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Asset_Pooling_Rule_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
