<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Phase_PO_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Plan Phase must be a Project Plan Phase for the selected Project. | Element Containing Project Plan Phase Data.
 * @subpackage Structs
 */
class Project_Plan_Phase_PO_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Plan Phase.
     * @var \StructType\Project_Plan_PhaseObjectType
     */
    public $Project_Plan_Phase_Reference;
    /**
     * The Project_Plan_Task_Data
     * Meta information extracted from the WSDL
     * - documentation: Element Containing Project Plan Task Data. A Project-Based Order Line may have multiple project subtasks of multiple project plan tasks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Task_PO_DataType[]
     */
    public $Project_Plan_Task_Data;
    /**
     * Constructor method for Project_Plan_Phase_PO_DataType
     * @uses Project_Plan_Phase_PO_DataType::setProject_Plan_Phase_Reference()
     * @uses Project_Plan_Phase_PO_DataType::setProject_Plan_Task_Data()
     * @param \StructType\Project_Plan_PhaseObjectType $project_Plan_Phase_Reference
     * @param \StructType\Project_Plan_Task_PO_DataType[] $project_Plan_Task_Data
     */
    public function __construct(\StructType\Project_Plan_PhaseObjectType $project_Plan_Phase_Reference = null, array $project_Plan_Task_Data = array())
    {
        $this
            ->setProject_Plan_Phase_Reference($project_Plan_Phase_Reference)
            ->setProject_Plan_Task_Data($project_Plan_Task_Data);
    }
    /**
     * Get Project_Plan_Phase_Reference value
     * @return \StructType\Project_Plan_PhaseObjectType|null
     */
    public function getProject_Plan_Phase_Reference()
    {
        return $this->Project_Plan_Phase_Reference;
    }
    /**
     * Set Project_Plan_Phase_Reference value
     * @param \StructType\Project_Plan_PhaseObjectType $project_Plan_Phase_Reference
     * @return \StructType\Project_Plan_Phase_PO_DataType
     */
    public function setProject_Plan_Phase_Reference(\StructType\Project_Plan_PhaseObjectType $project_Plan_Phase_Reference = null)
    {
        $this->Project_Plan_Phase_Reference = $project_Plan_Phase_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Task_Data value
     * @return \StructType\Project_Plan_Task_PO_DataType[]|null
     */
    public function getProject_Plan_Task_Data()
    {
        return $this->Project_Plan_Task_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Task_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Task_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_Task_DataForArrayConstraintsFromSetProject_Plan_Task_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem instanceof \StructType\Project_Plan_Task_PO_DataType) {
                $invalidValues[] = is_object($project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem) ? get_class($project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem), var_export($project_Plan_Phase_PO_DataTypeProject_Plan_Task_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Task_Data property can only contain items of type \StructType\Project_Plan_Task_PO_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_PO_DataType[] $project_Plan_Task_Data
     * @return \StructType\Project_Plan_Phase_PO_DataType
     */
    public function setProject_Plan_Task_Data(array $project_Plan_Task_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_Task_DataArrayErrorMessage = self::validateProject_Plan_Task_DataForArrayConstraintsFromSetProject_Plan_Task_Data($project_Plan_Task_Data))) {
            throw new \InvalidArgumentException($project_Plan_Task_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Task_Data = $project_Plan_Task_Data;
        return $this;
    }
    /**
     * Add item to Project_Plan_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_PO_DataType $item
     * @return \StructType\Project_Plan_Phase_PO_DataType
     */
    public function addToProject_Plan_Task_Data(\StructType\Project_Plan_Task_PO_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Task_PO_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Task_Data property can only contain items of type \StructType\Project_Plan_Task_PO_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Task_Data[] = $item;
        return $this;
    }
}
