<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Provider_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria used to retrieve Internal Service Providers.
 * @subpackage Structs
 */
class Internal_Service_Provider_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing companies or company hierarchies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Internal_Service_Provider_Name
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Provider Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Provider_Name;
    /**
     * The Internal_Service_Provider_ID
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Provider ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Provider_ID;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: In inactive status or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing currency for an Internal Service Provider.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Currency_Reference;
    /**
     * Constructor method for Internal_Service_Provider_Request_CriteriaType
     * @uses Internal_Service_Provider_Request_CriteriaType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Internal_Service_Provider_Request_CriteriaType::setInternal_Service_Provider_Name()
     * @uses Internal_Service_Provider_Request_CriteriaType::setInternal_Service_Provider_ID()
     * @uses Internal_Service_Provider_Request_CriteriaType::setInactive()
     * @uses Internal_Service_Provider_Request_CriteriaType::setCurrency_Reference()
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @param string $internal_Service_Provider_Name
     * @param string $internal_Service_Provider_ID
     * @param bool $inactive
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     */
    public function __construct(array $company_or_Company_Hierarchy_Reference = array(), $internal_Service_Provider_Name = null, $internal_Service_Provider_ID = null, $inactive = null, array $currency_Reference = array())
    {
        $this
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setInternal_Service_Provider_Name($internal_Service_Provider_Name)
            ->setInternal_Service_Provider_ID($internal_Service_Provider_ID)
            ->setInactive($inactive)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_or_Company_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_or_Company_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) ? get_class($internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem), var_export($internal_Service_Provider_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function setCompany_or_Company_Hierarchy_Reference(array $company_or_Company_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_or_Company_Hierarchy_ReferenceArrayErrorMessage = self::validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($company_or_Company_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function addToCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Name value
     * @return string|null
     */
    public function getInternal_Service_Provider_Name()
    {
        return $this->Internal_Service_Provider_Name;
    }
    /**
     * Set Internal_Service_Provider_Name value
     * @param string $internal_Service_Provider_Name
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function setInternal_Service_Provider_Name($internal_Service_Provider_Name = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Provider_Name) && !is_string($internal_Service_Provider_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Provider_Name, true), gettype($internal_Service_Provider_Name)), __LINE__);
        }
        $this->Internal_Service_Provider_Name = $internal_Service_Provider_Name;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_ID value
     * @return string|null
     */
    public function getInternal_Service_Provider_ID()
    {
        return $this->Internal_Service_Provider_ID;
    }
    /**
     * Set Internal_Service_Provider_ID value
     * @param string $internal_Service_Provider_ID
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function setInternal_Service_Provider_ID($internal_Service_Provider_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Provider_ID) && !is_string($internal_Service_Provider_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Provider_ID, true), gettype($internal_Service_Provider_ID)), __LINE__);
        }
        $this->Internal_Service_Provider_ID = $internal_Service_Provider_ID;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem) ? get_class($internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem), var_export($internal_Service_Provider_Request_CriteriaTypeCurrency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function setCurrency_Reference(array $currency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_ReferenceArrayErrorMessage = self::validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference($currency_Reference))) {
            throw new \InvalidArgumentException($currency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Add item to Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Internal_Service_Provider_Request_CriteriaType
     */
    public function addToCurrency_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Reference[] = $item;
        return $this;
    }
}
