<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer_Invoice_for_Netting_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer Invoice for Netting Data
 * @subpackage Structs
 */
class Customer_Invoice_for_Netting_DataType extends AbstractStructBase
{
    /**
     * The Customer_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: The invoices must be approved and not fully paid. | Remove the invoices with withholding tax payment realization tax code. | Reference to an existing customer invoice.
     * - choice: Customer_Invoice_Reference | Customer_Invoice_Adjustment_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Customer_InvoiceObjectType
     */
    public $Customer_Invoice_Reference;
    /**
     * The Customer_Invoice_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The invoices must be approved and not fully paid. | Remove the invoices with withholding tax payment realization tax code. | Reference to an existing Customer Invoice Adjustment
     * - choice: Customer_Invoice_Reference | Customer_Invoice_Adjustment_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Customer_Invoice_AdjustmentObjectType
     */
    public $Customer_Invoice_Adjustment_Reference;
    /**
     * The Amount_to_Net
     * Meta information extracted from the WSDL
     * - documentation: Enter a negative amount to net for a negative supplier invoice. | Enter a negative amount to net for negative supplier invoice adjustments. | Amount to net for the referenced invoice document. | Enter an amount to net that is greater
     * than or equal to the amount due on these negative documents:* Supplier invoice * Supplier invoice adjustment* Customer invoice * Customer invoice adjustment | Enter a negative amount to net for negative customer invoice adjustments. | Enter an amount
     * to net greater than zero on these transactions:* positive customer invoice adjustments* positive customer invoices* positive supplier invoice adjustments* positive supplier invoices | Enter a negative amount to net for a negative customer invoice. |
     * Enter an amount to net not equal to zero. | Enter an amount to net that is equal to or less than the amount due on the invoice.
     * - base: xsd:decimal
     * - fractionDigits: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 30
     * @var float
     */
    public $Amount_to_Net;
    /**
     * The Amount_Netted
     * Meta information extracted from the WSDL
     * - documentation: Amount netted for the Referenced Supplier Invoice Document. Read Only. | Amount netted for the Referenced Customer Invoice Document. Read Only
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount_Netted;
    /**
     * Constructor method for Customer_Invoice_for_Netting_DataType
     * @uses Customer_Invoice_for_Netting_DataType::setCustomer_Invoice_Reference()
     * @uses Customer_Invoice_for_Netting_DataType::setCustomer_Invoice_Adjustment_Reference()
     * @uses Customer_Invoice_for_Netting_DataType::setAmount_to_Net()
     * @uses Customer_Invoice_for_Netting_DataType::setAmount_Netted()
     * @param \StructType\Customer_InvoiceObjectType $customer_Invoice_Reference
     * @param \StructType\Customer_Invoice_AdjustmentObjectType $customer_Invoice_Adjustment_Reference
     * @param float $amount_to_Net
     * @param float $amount_Netted
     */
    public function __construct(\StructType\Customer_InvoiceObjectType $customer_Invoice_Reference = null, \StructType\Customer_Invoice_AdjustmentObjectType $customer_Invoice_Adjustment_Reference = null, $amount_to_Net = null, $amount_Netted = null)
    {
        $this
            ->setCustomer_Invoice_Reference($customer_Invoice_Reference)
            ->setCustomer_Invoice_Adjustment_Reference($customer_Invoice_Adjustment_Reference)
            ->setAmount_to_Net($amount_to_Net)
            ->setAmount_Netted($amount_Netted);
    }
    /**
     * Get Customer_Invoice_Reference value
     * @return \StructType\Customer_InvoiceObjectType|null
     */
    public function getCustomer_Invoice_Reference()
    {
        return isset($this->Customer_Invoice_Reference) ? $this->Customer_Invoice_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCustomer_Invoice_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer_Invoice_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCustomer_Invoice_ReferenceForChoiceConstraintsFromSetCustomer_Invoice_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Customer_Invoice_Adjustment_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Customer_Invoice_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Customer_Invoice_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Customer_Invoice_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Customer_InvoiceObjectType $customer_Invoice_Reference
     * @return \StructType\Customer_Invoice_for_Netting_DataType
     */
    public function setCustomer_Invoice_Reference(\StructType\Customer_InvoiceObjectType $customer_Invoice_Reference = null)
    {
        // validation for constraint: choice(Customer_Invoice_Reference, Customer_Invoice_Adjustment_Reference)
        if ('' !== ($customer_Invoice_ReferenceChoiceErrorMessage = self::validateCustomer_Invoice_ReferenceForChoiceConstraintsFromSetCustomer_Invoice_Reference($customer_Invoice_Reference))) {
            throw new \InvalidArgumentException($customer_Invoice_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($customer_Invoice_Reference) || (is_array($customer_Invoice_Reference) && empty($customer_Invoice_Reference))) {
            unset($this->Customer_Invoice_Reference);
        } else {
            $this->Customer_Invoice_Reference = $customer_Invoice_Reference;
        }
        return $this;
    }
    /**
     * Get Customer_Invoice_Adjustment_Reference value
     * @return \StructType\Customer_Invoice_AdjustmentObjectType|null
     */
    public function getCustomer_Invoice_Adjustment_Reference()
    {
        return isset($this->Customer_Invoice_Adjustment_Reference) ? $this->Customer_Invoice_Adjustment_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCustomer_Invoice_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer_Invoice_Adjustment_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCustomer_Invoice_Adjustment_ReferenceForChoiceConstraintsFromSetCustomer_Invoice_Adjustment_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Customer_Invoice_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Customer_Invoice_Adjustment_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Customer_Invoice_Adjustment_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Customer_Invoice_Adjustment_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Customer_Invoice_AdjustmentObjectType $customer_Invoice_Adjustment_Reference
     * @return \StructType\Customer_Invoice_for_Netting_DataType
     */
    public function setCustomer_Invoice_Adjustment_Reference(\StructType\Customer_Invoice_AdjustmentObjectType $customer_Invoice_Adjustment_Reference = null)
    {
        // validation for constraint: choice(Customer_Invoice_Reference, Customer_Invoice_Adjustment_Reference)
        if ('' !== ($customer_Invoice_Adjustment_ReferenceChoiceErrorMessage = self::validateCustomer_Invoice_Adjustment_ReferenceForChoiceConstraintsFromSetCustomer_Invoice_Adjustment_Reference($customer_Invoice_Adjustment_Reference))) {
            throw new \InvalidArgumentException($customer_Invoice_Adjustment_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($customer_Invoice_Adjustment_Reference) || (is_array($customer_Invoice_Adjustment_Reference) && empty($customer_Invoice_Adjustment_Reference))) {
            unset($this->Customer_Invoice_Adjustment_Reference);
        } else {
            $this->Customer_Invoice_Adjustment_Reference = $customer_Invoice_Adjustment_Reference;
        }
        return $this;
    }
    /**
     * Get Amount_to_Net value
     * @return float|null
     */
    public function getAmount_to_Net()
    {
        return $this->Amount_to_Net;
    }
    /**
     * Set Amount_to_Net value
     * @param float $amount_to_Net
     * @return \StructType\Customer_Invoice_for_Netting_DataType
     */
    public function setAmount_to_Net($amount_to_Net = null)
    {
        // validation for constraint: float
        if (!is_null($amount_to_Net) && !(is_float($amount_to_Net) || is_numeric($amount_to_Net))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_to_Net, true), gettype($amount_to_Net)), __LINE__);
        }
        // validation for constraint: fractionDigits(10)
        if (!is_null($amount_to_Net) && mb_strlen(mb_substr($amount_to_Net, false !== mb_strpos($amount_to_Net, '.') ? mb_strpos($amount_to_Net, '.') + 1 : mb_strlen($amount_to_Net))) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 10 fraction digits, %d given', var_export($amount_to_Net, true), mb_strlen(mb_substr($amount_to_Net, mb_strpos($amount_to_Net, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(30)
        if (!is_null($amount_to_Net) && mb_strlen(preg_replace('/(\D)/', '', $amount_to_Net)) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 30 digits, "%d" given', var_export($amount_to_Net, true), mb_strlen(preg_replace('/(\D)/', '', $amount_to_Net))), __LINE__);
        }
        $this->Amount_to_Net = $amount_to_Net;
        return $this;
    }
    /**
     * Get Amount_Netted value
     * @return float|null
     */
    public function getAmount_Netted()
    {
        return $this->Amount_Netted;
    }
    /**
     * Set Amount_Netted value
     * @param float $amount_Netted
     * @return \StructType\Customer_Invoice_for_Netting_DataType
     */
    public function setAmount_Netted($amount_Netted = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Netted) && !(is_float($amount_Netted) || is_numeric($amount_Netted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Netted, true), gettype($amount_Netted)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount_Netted) && mb_strlen(mb_substr($amount_Netted, false !== mb_strpos($amount_Netted, '.') ? mb_strpos($amount_Netted, '.') + 1 : mb_strlen($amount_Netted))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount_Netted, true), mb_strlen(mb_substr($amount_Netted, mb_strpos($amount_Netted, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount_Netted) && mb_strlen(preg_replace('/(\D)/', '', $amount_Netted)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount_Netted, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Netted))), __LINE__);
        }
        $this->Amount_Netted = $amount_Netted;
        return $this;
    }
}
