<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bulk_Import_Transfer_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for processing many instances of Asset.
 * @subpackage Structs
 */
class Bulk_Import_Transfer_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Transfer_Asset_Request
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transfer_Asset_RequestType[]
     */
    public $Transfer_Asset_Request;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Bulk_Import_Transfer_Asset_RequestType
     * @uses Bulk_Import_Transfer_Asset_RequestType::setTransfer_Asset_Request()
     * @uses Bulk_Import_Transfer_Asset_RequestType::setVersion()
     * @param \StructType\Transfer_Asset_RequestType[] $transfer_Asset_Request
     * @param string $version
     */
    public function __construct(array $transfer_Asset_Request = array(), $version = null)
    {
        $this
            ->setTransfer_Asset_Request($transfer_Asset_Request)
            ->setVersion($version);
    }
    /**
     * Get Transfer_Asset_Request value
     * @return \StructType\Transfer_Asset_RequestType[]|null
     */
    public function getTransfer_Asset_Request()
    {
        return $this->Transfer_Asset_Request;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Asset_Request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Asset_Request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Asset_RequestForArrayConstraintsFromSetTransfer_Asset_Request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem) {
            // validation for constraint: itemType
            if (!$bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem instanceof \StructType\Transfer_Asset_RequestType) {
                $invalidValues[] = is_object($bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem) ? get_class($bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem) : sprintf('%s(%s)', gettype($bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem), var_export($bulk_Import_Transfer_Asset_RequestTypeTransfer_Asset_RequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Asset_Request property can only contain items of type \StructType\Transfer_Asset_RequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Asset_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Asset_RequestType[] $transfer_Asset_Request
     * @return \StructType\Bulk_Import_Transfer_Asset_RequestType
     */
    public function setTransfer_Asset_Request(array $transfer_Asset_Request = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Asset_RequestArrayErrorMessage = self::validateTransfer_Asset_RequestForArrayConstraintsFromSetTransfer_Asset_Request($transfer_Asset_Request))) {
            throw new \InvalidArgumentException($transfer_Asset_RequestArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Asset_Request = $transfer_Asset_Request;
        return $this;
    }
    /**
     * Add item to Transfer_Asset_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Asset_RequestType $item
     * @return \StructType\Bulk_Import_Transfer_Asset_RequestType
     */
    public function addToTransfer_Asset_Request(\StructType\Transfer_Asset_RequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Asset_RequestType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Asset_Request property can only contain items of type \StructType\Transfer_Asset_RequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Asset_Request[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Bulk_Import_Transfer_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
