<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Components_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains an asset component.
 * @subpackage Structs
 */
class Asset_Components_WWS_DataType extends AbstractStructBase
{
    /**
     * The Component_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: A Business Asset that is an asset component.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Component_Asset_Reference;
    /**
     * The Asset_Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the asset component.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Description;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Total_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Purchase Order AmountcXML Notes:Request/OrderRequest/OrderRequestHeader/Total/MoneyThis is the Sum of the Extended Amount of all of the Purchase Order Lines. | Total cost of the asset component. | READ ONLY: Total cost of the
     * business asset.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Cost;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Asset Identifier of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: Asset Manufacturer of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference of the Asset Component
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: Asset Name of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The PO_Number
     * Meta information extracted from the WSDL
     * - documentation: PO Number of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Number;
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: Receipt Number of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The XMLNAME__Project__Number
     * Meta information extracted from the WSDL
     * - documentation: Project Number of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XMLNAME__Project__Number;
    /**
     * The Supplier_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Number of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Number;
    /**
     * The External_Contract_Number
     * Meta information extracted from the WSDL
     * - documentation: Contract Number of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Number;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo of the Asset Component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Asset_Components_WWS_DataType
     * @uses Asset_Components_WWS_DataType::setComponent_Asset_Reference()
     * @uses Asset_Components_WWS_DataType::setAsset_Description()
     * @uses Asset_Components_WWS_DataType::setQuantity()
     * @uses Asset_Components_WWS_DataType::setUnit_Cost()
     * @uses Asset_Components_WWS_DataType::setTotal_Cost()
     * @uses Asset_Components_WWS_DataType::setAsset_Identifier()
     * @uses Asset_Components_WWS_DataType::setSupplier_Reference_Number()
     * @uses Asset_Components_WWS_DataType::setManufacturer()
     * @uses Asset_Components_WWS_DataType::setItem_Reference()
     * @uses Asset_Components_WWS_DataType::setAsset_Name()
     * @uses Asset_Components_WWS_DataType::setPO_Number()
     * @uses Asset_Components_WWS_DataType::setReceipt_Number()
     * @uses Asset_Components_WWS_DataType::setXMLNAME__Project__Number()
     * @uses Asset_Components_WWS_DataType::setSupplier_Invoice_Number()
     * @uses Asset_Components_WWS_DataType::setExternal_Contract_Number()
     * @uses Asset_Components_WWS_DataType::setMemo()
     * @param \StructType\Business_AssetObjectType $component_Asset_Reference
     * @param string $asset_Description
     * @param float $quantity
     * @param float $unit_Cost
     * @param float $total_Cost
     * @param string $asset_Identifier
     * @param string $supplier_Reference_Number
     * @param string $manufacturer
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $asset_Name
     * @param string $pO_Number
     * @param string $receipt_Number
     * @param string $xMLNAME__Project__Number
     * @param string $supplier_Invoice_Number
     * @param string $external_Contract_Number
     * @param string $memo
     */
    public function __construct(\StructType\Business_AssetObjectType $component_Asset_Reference = null, $asset_Description = null, $quantity = null, $unit_Cost = null, $total_Cost = null, $asset_Identifier = null, $supplier_Reference_Number = null, $manufacturer = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $asset_Name = null, $pO_Number = null, $receipt_Number = null, $xMLNAME__Project__Number = null, $supplier_Invoice_Number = null, $external_Contract_Number = null, $memo = null)
    {
        $this
            ->setComponent_Asset_Reference($component_Asset_Reference)
            ->setAsset_Description($asset_Description)
            ->setQuantity($quantity)
            ->setUnit_Cost($unit_Cost)
            ->setTotal_Cost($total_Cost)
            ->setAsset_Identifier($asset_Identifier)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setManufacturer($manufacturer)
            ->setItem_Reference($item_Reference)
            ->setAsset_Name($asset_Name)
            ->setPO_Number($pO_Number)
            ->setReceipt_Number($receipt_Number)
            ->setXMLNAME__Project__Number($xMLNAME__Project__Number)
            ->setSupplier_Invoice_Number($supplier_Invoice_Number)
            ->setExternal_Contract_Number($external_Contract_Number)
            ->setMemo($memo);
    }
    /**
     * Get Component_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getComponent_Asset_Reference()
    {
        return $this->Component_Asset_Reference;
    }
    /**
     * Set Component_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $component_Asset_Reference
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setComponent_Asset_Reference(\StructType\Business_AssetObjectType $component_Asset_Reference = null)
    {
        $this->Component_Asset_Reference = $component_Asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Description value
     * @return string|null
     */
    public function getAsset_Description()
    {
        return $this->Asset_Description;
    }
    /**
     * Set Asset_Description value
     * @param string $asset_Description
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setAsset_Description($asset_Description = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Description) && !is_string($asset_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Description, true), gettype($asset_Description)), __LINE__);
        }
        $this->Asset_Description = $asset_Description;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Total_Cost value
     * @return float|null
     */
    public function getTotal_Cost()
    {
        return $this->Total_Cost;
    }
    /**
     * Set Total_Cost value
     * @param float $total_Cost
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setTotal_Cost($total_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Cost) && !(is_float($total_Cost) || is_numeric($total_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Cost, true), gettype($total_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Cost) && mb_strlen(mb_substr($total_Cost, false !== mb_strpos($total_Cost, '.') ? mb_strpos($total_Cost, '.') + 1 : mb_strlen($total_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Cost, true), mb_strlen(mb_substr($total_Cost, mb_strpos($total_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Cost))), __LINE__);
        }
        $this->Total_Cost = $total_Cost;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get PO_Number value
     * @return string|null
     */
    public function getPO_Number()
    {
        return $this->PO_Number;
    }
    /**
     * Set PO_Number value
     * @param string $pO_Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setPO_Number($pO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Number) && !is_string($pO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Number, true), gettype($pO_Number)), __LINE__);
        }
        $this->PO_Number = $pO_Number;
        return $this;
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get XMLNAME__Project__Number value
     * @return string|null
     */
    public function getXMLNAME__Project__Number()
    {
        return $this->XMLNAME__Project__Number;
    }
    /**
     * Set XMLNAME__Project__Number value
     * @param string $xMLNAME__Project__Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setXMLNAME__Project__Number($xMLNAME__Project__Number = null)
    {
        // validation for constraint: string
        if (!is_null($xMLNAME__Project__Number) && !is_string($xMLNAME__Project__Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xMLNAME__Project__Number, true), gettype($xMLNAME__Project__Number)), __LINE__);
        }
        $this->XMLNAME__Project__Number = $xMLNAME__Project__Number;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Number()
    {
        return $this->Supplier_Invoice_Number;
    }
    /**
     * Set Supplier_Invoice_Number value
     * @param string $supplier_Invoice_Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setSupplier_Invoice_Number($supplier_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Number) && !is_string($supplier_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Number, true), gettype($supplier_Invoice_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Number = $supplier_Invoice_Number;
        return $this;
    }
    /**
     * Get External_Contract_Number value
     * @return string|null
     */
    public function getExternal_Contract_Number()
    {
        return $this->External_Contract_Number;
    }
    /**
     * Set External_Contract_Number value
     * @param string $external_Contract_Number
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setExternal_Contract_Number($external_Contract_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Number) && !is_string($external_Contract_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Number, true), gettype($external_Contract_Number)), __LINE__);
        }
        $this->External_Contract_Number = $external_Contract_Number;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Asset_Components_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
