<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Bulk_Import_Submit_Supplier
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Supplier asynchronously.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Submit_Supplier_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Submit_Supplier(\StructType\Bulk_Import_Submit_Supplier_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Submit_Supplier($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Bulk_Import_Adjust_Asset_Cost
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Asset Cost asynchronously.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Adjust_Asset_Cost_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Adjust_Asset_Cost(\StructType\Bulk_Import_Adjust_Asset_Cost_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Adjust_Asset_Cost($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Bulk_Import_Asset_Book_Configuration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Asset Book Configuration asynchronously.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Asset_Book_Configuration(\StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Asset_Book_Configuration($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Bulk_Import_Transfer_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Asset asynchronously.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Transfer_Asset_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Transfer_Asset(\StructType\Bulk_Import_Transfer_Asset_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Transfer_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Bulk_Import_Dispose_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Asset asynchronously.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Dispose_Asset_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Dispose_Asset(\StructType\Bulk_Import_Dispose_Asset_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Dispose_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Bulk_Import_Submit_Remit_To_Supplier_Connection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Remit To Supplier Connection asynchronously.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Submit_Remit_To_Supplier_Connection_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Submit_Remit_To_Supplier_Connection(\StructType\Bulk_Import_Submit_Remit_To_Supplier_Connection_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Submit_Remit_To_Supplier_Connection($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Bulk_Import_Register_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Processes many instances of Asset asynchronously.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Bulk_Import_Register_Asset_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Bulk_Import_Register_Asset(\StructType\Bulk_Import_Register_Asset_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Bulk_Import_Register_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Put_Import_Process_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
