<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Spend_Category_Hierarchy_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Spend Category Hierarchy reference for update and all Spend Category Hierarchy data items
 * @subpackage Structs
 */
class Put_Spend_Category_Hierarchy_RequestType extends AbstractStructBase
{
    /**
     * The Spend_Category_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category Hierarchy.
     * - minOccurs: 0
     * @var \StructType\Spend_Category_HierarchyObjectType
     */
    public $Spend_Category_Hierarchy_Reference;
    /**
     * The Spend_Category_Hierarchy_Data
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Hierarchy Data
     * - minOccurs: 0
     * @var \StructType\Spend_Category_Hierarchy_DataType
     */
    public $Spend_Category_Hierarchy_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Spend_Category_Hierarchy_RequestType
     * @uses Put_Spend_Category_Hierarchy_RequestType::setSpend_Category_Hierarchy_Reference()
     * @uses Put_Spend_Category_Hierarchy_RequestType::setSpend_Category_Hierarchy_Data()
     * @uses Put_Spend_Category_Hierarchy_RequestType::setAdd_Only()
     * @uses Put_Spend_Category_Hierarchy_RequestType::setVersion()
     * @param \StructType\Spend_Category_HierarchyObjectType $spend_Category_Hierarchy_Reference
     * @param \StructType\Spend_Category_Hierarchy_DataType $spend_Category_Hierarchy_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Spend_Category_HierarchyObjectType $spend_Category_Hierarchy_Reference = null, \StructType\Spend_Category_Hierarchy_DataType $spend_Category_Hierarchy_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSpend_Category_Hierarchy_Reference($spend_Category_Hierarchy_Reference)
            ->setSpend_Category_Hierarchy_Data($spend_Category_Hierarchy_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Spend_Category_Hierarchy_Reference value
     * @return \StructType\Spend_Category_HierarchyObjectType|null
     */
    public function getSpend_Category_Hierarchy_Reference()
    {
        return $this->Spend_Category_Hierarchy_Reference;
    }
    /**
     * Set Spend_Category_Hierarchy_Reference value
     * @param \StructType\Spend_Category_HierarchyObjectType $spend_Category_Hierarchy_Reference
     * @return \StructType\Put_Spend_Category_Hierarchy_RequestType
     */
    public function setSpend_Category_Hierarchy_Reference(\StructType\Spend_Category_HierarchyObjectType $spend_Category_Hierarchy_Reference = null)
    {
        $this->Spend_Category_Hierarchy_Reference = $spend_Category_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Hierarchy_Data value
     * @return \StructType\Spend_Category_Hierarchy_DataType|null
     */
    public function getSpend_Category_Hierarchy_Data()
    {
        return $this->Spend_Category_Hierarchy_Data;
    }
    /**
     * Set Spend_Category_Hierarchy_Data value
     * @param \StructType\Spend_Category_Hierarchy_DataType $spend_Category_Hierarchy_Data
     * @return \StructType\Put_Spend_Category_Hierarchy_RequestType
     */
    public function setSpend_Category_Hierarchy_Data(\StructType\Spend_Category_Hierarchy_DataType $spend_Category_Hierarchy_Data = null)
    {
        $this->Spend_Category_Hierarchy_Data = $spend_Category_Hierarchy_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Spend_Category_Hierarchy_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Spend_Category_Hierarchy_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
