<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multi-Participant_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multi-Participant Data
 * @subpackage Structs
 */
class Multi_Participant_DataType extends AbstractStructBase
{
    /**
     * The Participant_List_Entry_Data
     * Meta information extracted from the WSDL
     * - documentation: Participant List Entry Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Participant_List_Entry_DataType[]
     */
    public $Participant_List_Entry_Data;
    /**
     * Constructor method for Multi-Participant_DataType
     * @uses Multi_Participant_DataType::setParticipant_List_Entry_Data()
     * @param \StructType\Supplier_Contract_Participant_List_Entry_DataType[] $participant_List_Entry_Data
     */
    public function __construct(array $participant_List_Entry_Data = array())
    {
        $this
            ->setParticipant_List_Entry_Data($participant_List_Entry_Data);
    }
    /**
     * Get Participant_List_Entry_Data value
     * @return \StructType\Supplier_Contract_Participant_List_Entry_DataType[]|null
     */
    public function getParticipant_List_Entry_Data()
    {
        return $this->Participant_List_Entry_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setParticipant_List_Entry_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParticipant_List_Entry_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParticipant_List_Entry_DataForArrayConstraintsFromSetParticipant_List_Entry_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $multi_Participant_DataTypeParticipant_List_Entry_DataItem) {
            // validation for constraint: itemType
            if (!$multi_Participant_DataTypeParticipant_List_Entry_DataItem instanceof \StructType\Supplier_Contract_Participant_List_Entry_DataType) {
                $invalidValues[] = is_object($multi_Participant_DataTypeParticipant_List_Entry_DataItem) ? get_class($multi_Participant_DataTypeParticipant_List_Entry_DataItem) : sprintf('%s(%s)', gettype($multi_Participant_DataTypeParticipant_List_Entry_DataItem), var_export($multi_Participant_DataTypeParticipant_List_Entry_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Participant_List_Entry_Data property can only contain items of type \StructType\Supplier_Contract_Participant_List_Entry_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Participant_List_Entry_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Participant_List_Entry_DataType[] $participant_List_Entry_Data
     * @return \StructType\Multi_Participant_DataType
     */
    public function setParticipant_List_Entry_Data(array $participant_List_Entry_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($participant_List_Entry_DataArrayErrorMessage = self::validateParticipant_List_Entry_DataForArrayConstraintsFromSetParticipant_List_Entry_Data($participant_List_Entry_Data))) {
            throw new \InvalidArgumentException($participant_List_Entry_DataArrayErrorMessage, __LINE__);
        }
        $this->Participant_List_Entry_Data = $participant_List_Entry_Data;
        return $this;
    }
    /**
     * Add item to Participant_List_Entry_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Participant_List_Entry_DataType $item
     * @return \StructType\Multi_Participant_DataType
     */
    public function addToParticipant_List_Entry_Data(\StructType\Supplier_Contract_Participant_List_Entry_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Participant_List_Entry_DataType) {
            throw new \InvalidArgumentException(sprintf('The Participant_List_Entry_Data property can only contain items of type \StructType\Supplier_Contract_Participant_List_Entry_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Participant_List_Entry_Data[] = $item;
        return $this;
    }
}
