<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Utilization_Target_Sheets_Response_GroupType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Container for Worker Utilization Target Sheets Response Group
 * @subpackage Structs
 */
class Worker_Utilization_Target_Sheets_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference of the Worker Utilization Target Sheet is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Worker_Utilization_Target_Sheet_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the details of the Worker Utilization Target Sheet is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Worker_Utilization_Target_Sheet_Data;
    /**
     * Constructor method for Worker_Utilization_Target_Sheets_Response_GroupType
     * @uses Worker_Utilization_Target_Sheets_Response_GroupType::setInclude_Reference()
     * @uses Worker_Utilization_Target_Sheets_Response_GroupType::setInclude_Worker_Utilization_Target_Sheet_Data()
     * @param bool $include_Reference
     * @param bool $include_Worker_Utilization_Target_Sheet_Data
     */
    public function __construct($include_Reference = null, $include_Worker_Utilization_Target_Sheet_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Worker_Utilization_Target_Sheet_Data($include_Worker_Utilization_Target_Sheet_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Worker_Utilization_Target_Sheets_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Worker_Utilization_Target_Sheet_Data value
     * @return bool|null
     */
    public function getInclude_Worker_Utilization_Target_Sheet_Data()
    {
        return $this->Include_Worker_Utilization_Target_Sheet_Data;
    }
    /**
     * Set Include_Worker_Utilization_Target_Sheet_Data value
     * @param bool $include_Worker_Utilization_Target_Sheet_Data
     * @return \StructType\Worker_Utilization_Target_Sheets_Response_GroupType
     */
    public function setInclude_Worker_Utilization_Target_Sheet_Data($include_Worker_Utilization_Target_Sheet_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Worker_Utilization_Target_Sheet_Data) && !is_bool($include_Worker_Utilization_Target_Sheet_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Worker_Utilization_Target_Sheet_Data, true), gettype($include_Worker_Utilization_Target_Sheet_Data)), __LINE__);
        }
        $this->Include_Worker_Utilization_Target_Sheet_Data = $include_Worker_Utilization_Target_Sheet_Data;
        return $this;
    }
}
