<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Withholding_Tax_Code_Application_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing Withholding Tax Details data
 * @subpackage Structs
 */
class Withholding_Tax_Code_Application_DataType extends AbstractStructBase
{
    /**
     * The Withholding_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the withholding tax code.If this is blank, Workday will default in the default withholding tax code from the invoice header if there is one.
     * @var \StructType\Tax_CodeObjectType
     */
    public $Withholding_Tax_Code_Reference;
    /**
     * The Withholding_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Withholding Tax Amount | Total Tax Amount for Withholding Tax Code
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Withholding_Tax_Amount;
    /**
     * The Withholding_Tax_Rate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Tax_Rate_Application_DataType[]
     */
    public $Withholding_Tax_Rate_Data;
    /**
     * Constructor method for Withholding_Tax_Code_Application_DataType
     * @uses Withholding_Tax_Code_Application_DataType::setWithholding_Tax_Code_Reference()
     * @uses Withholding_Tax_Code_Application_DataType::setWithholding_Tax_Amount()
     * @uses Withholding_Tax_Code_Application_DataType::setWithholding_Tax_Rate_Data()
     * @param \StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference
     * @param float $withholding_Tax_Amount
     * @param \StructType\Tax_Rate_Application_DataType[] $withholding_Tax_Rate_Data
     */
    public function __construct(\StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference = null, $withholding_Tax_Amount = null, array $withholding_Tax_Rate_Data = array())
    {
        $this
            ->setWithholding_Tax_Code_Reference($withholding_Tax_Code_Reference)
            ->setWithholding_Tax_Amount($withholding_Tax_Amount)
            ->setWithholding_Tax_Rate_Data($withholding_Tax_Rate_Data);
    }
    /**
     * Get Withholding_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getWithholding_Tax_Code_Reference()
    {
        return $this->Withholding_Tax_Code_Reference;
    }
    /**
     * Set Withholding_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference
     * @return \StructType\Withholding_Tax_Code_Application_DataType
     */
    public function setWithholding_Tax_Code_Reference(\StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference = null)
    {
        $this->Withholding_Tax_Code_Reference = $withholding_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Withholding_Tax_Amount value
     * @return float|null
     */
    public function getWithholding_Tax_Amount()
    {
        return $this->Withholding_Tax_Amount;
    }
    /**
     * Set Withholding_Tax_Amount value
     * @param float $withholding_Tax_Amount
     * @return \StructType\Withholding_Tax_Code_Application_DataType
     */
    public function setWithholding_Tax_Amount($withholding_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($withholding_Tax_Amount) && !(is_float($withholding_Tax_Amount) || is_numeric($withholding_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withholding_Tax_Amount, true), gettype($withholding_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($withholding_Tax_Amount) && mb_strlen(mb_substr($withholding_Tax_Amount, false !== mb_strpos($withholding_Tax_Amount, '.') ? mb_strpos($withholding_Tax_Amount, '.') + 1 : mb_strlen($withholding_Tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($withholding_Tax_Amount, true), mb_strlen(mb_substr($withholding_Tax_Amount, mb_strpos($withholding_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($withholding_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $withholding_Tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($withholding_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $withholding_Tax_Amount))), __LINE__);
        }
        $this->Withholding_Tax_Amount = $withholding_Tax_Amount;
        return $this;
    }
    /**
     * Get Withholding_Tax_Rate_Data value
     * @return \StructType\Tax_Rate_Application_DataType[]|null
     */
    public function getWithholding_Tax_Rate_Data()
    {
        return $this->Withholding_Tax_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholding_Tax_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholding_Tax_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholding_Tax_Rate_DataForArrayConstraintsFromSetWithholding_Tax_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem instanceof \StructType\Tax_Rate_Application_DataType) {
                $invalidValues[] = is_object($withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem) ? get_class($withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem) : sprintf('%s(%s)', gettype($withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem), var_export($withholding_Tax_Code_Application_DataTypeWithholding_Tax_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Withholding_Tax_Rate_Data property can only contain items of type \StructType\Tax_Rate_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Withholding_Tax_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Application_DataType[] $withholding_Tax_Rate_Data
     * @return \StructType\Withholding_Tax_Code_Application_DataType
     */
    public function setWithholding_Tax_Rate_Data(array $withholding_Tax_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($withholding_Tax_Rate_DataArrayErrorMessage = self::validateWithholding_Tax_Rate_DataForArrayConstraintsFromSetWithholding_Tax_Rate_Data($withholding_Tax_Rate_Data))) {
            throw new \InvalidArgumentException($withholding_Tax_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Withholding_Tax_Rate_Data = $withholding_Tax_Rate_Data;
        return $this;
    }
    /**
     * Add item to Withholding_Tax_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Application_DataType $item
     * @return \StructType\Withholding_Tax_Code_Application_DataType
     */
    public function addToWithholding_Tax_Rate_Data(\StructType\Tax_Rate_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Rate_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Withholding_Tax_Rate_Data property can only contain items of type \StructType\Tax_Rate_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Withholding_Tax_Rate_Data[] = $item;
        return $this;
    }
}
