<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update_Asset_Useful_Life_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Business Process Parameters, Business Asset Reference for asset to update, and asset useful life update details
 * @subpackage Structs
 */
class Update_Asset_Useful_Life_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: You cannot adjust the useful life of this asset due to a problem with its depreciation start date not aligning with the first period in the depreciation schedule. Please contact Support for assistance. | Cannot update useful life of
     * an asset loaded into Workday as fully depreciated | Cannot update the useful life of this asset since it is either disposed or pending disposal | Cannot update useful life for this asset since accounting information has not been assigned yet | Cannot
     * update useful life for this asset since the accounting treatment is not depreciable capital | There is a pending event for the asset that should be completed before this asset transaction can be processed. | Reference to the Business Asset which
     * useful life need to be corrected or adjusted
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_Useful_Life_Update_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Asset useful life update data
     * @var \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public $Business_Asset_Useful_Life_Update_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Update_Asset_Useful_Life_RequestType
     * @uses Update_Asset_Useful_Life_RequestType::setBusiness_Asset_Reference()
     * @uses Update_Asset_Useful_Life_RequestType::setBusiness_Process_Parameters()
     * @uses Update_Asset_Useful_Life_RequestType::setBusiness_Asset_Useful_Life_Update_Data()
     * @uses Update_Asset_Useful_Life_RequestType::setVersion()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_Asset_Useful_Life_Update_DataType $business_Asset_Useful_Life_Update_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_Asset_Useful_Life_Update_DataType $business_Asset_Useful_Life_Update_Data = null, $version = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_Useful_Life_Update_Data($business_Asset_Useful_Life_Update_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Update_Asset_Useful_Life_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Update_Asset_Useful_Life_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_Useful_Life_Update_Data value
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType|null
     */
    public function getBusiness_Asset_Useful_Life_Update_Data()
    {
        return $this->Business_Asset_Useful_Life_Update_Data;
    }
    /**
     * Set Business_Asset_Useful_Life_Update_Data value
     * @param \StructType\Business_Asset_Useful_Life_Update_DataType $business_Asset_Useful_Life_Update_Data
     * @return \StructType\Update_Asset_Useful_Life_RequestType
     */
    public function setBusiness_Asset_Useful_Life_Update_Data(\StructType\Business_Asset_Useful_Life_Update_DataType $business_Asset_Useful_Life_Update_Data = null)
    {
        $this->Business_Asset_Useful_Life_Update_Data = $business_Asset_Useful_Life_Update_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Update_Asset_Useful_Life_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
