<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Unique Name Identifier Element
 * @subpackage Structs
 */
class Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The WID
     * Meta information extracted from the WSDL
     * - documentation: WID
     * - base: xsd:string
     * - maxLength: 36
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WID;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Email
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Full_Name
     * Meta information extracted from the WSDL
     * - documentation: Full Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Full_Name;
    /**
     * The Employee_ID
     * Meta information extracted from the WSDL
     * - documentation: Employee ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Employee_ID;
    /**
     * Constructor method for
     * Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setWID()
     * @uses Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setEmail()
     * @uses Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setFull_Name()
     * @uses Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setEmployee_ID()
     * @param string $wID
     * @param string $email
     * @param string $full_Name
     * @param string $employee_ID
     */
    public function __construct($wID = null, $email = null, $full_Name = null, $employee_ID = null)
    {
        $this
            ->setWID($wID)
            ->setEmail($email)
            ->setFull_Name($full_Name)
            ->setEmployee_ID($employee_ID);
    }
    /**
     * Get WID value
     * @return string|null
     */
    public function getWID()
    {
        return $this->WID;
    }
    /**
     * Set WID value
     * @param string $wID
     * @return \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setWID($wID = null)
    {
        // validation for constraint: string
        if (!is_null($wID) && !is_string($wID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wID, true), gettype($wID)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($wID) && mb_strlen($wID) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($wID)), __LINE__);
        }
        $this->WID = $wID;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Full_Name value
     * @return string|null
     */
    public function getFull_Name()
    {
        return $this->Full_Name;
    }
    /**
     * Set Full_Name value
     * @param string $full_Name
     * @return \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setFull_Name($full_Name = null)
    {
        // validation for constraint: string
        if (!is_null($full_Name) && !is_string($full_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($full_Name, true), gettype($full_Name)), __LINE__);
        }
        $this->Full_Name = $full_Name;
        return $this;
    }
    /**
     * Get Employee_ID value
     * @return string|null
     */
    public function getEmployee_ID()
    {
        return $this->Employee_ID;
    }
    /**
     * Set Employee_ID value
     * @param string $employee_ID
     * @return \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setEmployee_ID($employee_ID = null)
    {
        // validation for constraint: string
        if (!is_null($employee_ID) && !is_string($employee_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employee_ID, true), gettype($employee_ID)), __LINE__);
        }
        $this->Employee_ID = $employee_ID;
        return $this;
    }
}
