<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_RecordType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking Record
 * @subpackage Structs
 */
class Travel_Booking_RecordType extends AbstractStructBase
{
    /**
     * The Travel_Booking_Record_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Reference.
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_RecordObjectType
     */
    public $Travel_Booking_Record_Reference;
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense report linked to the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The Expense_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expensed status for the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Expense_StatusObjectType
     */
    public $Expense_Status_Reference;
    /**
     * The Travel_Booking_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File Reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_FileObjectType[]
     */
    public $Travel_Booking_File_Reference;
    /**
     * The Travel_Booking_Record_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_Record_DataType[]
     */
    public $Travel_Booking_Record_Data;
    /**
     * Constructor method for Travel_Booking_RecordType
     * @uses Travel_Booking_RecordType::setTravel_Booking_Record_Reference()
     * @uses Travel_Booking_RecordType::setExpense_Report_Reference()
     * @uses Travel_Booking_RecordType::setExpense_Status_Reference()
     * @uses Travel_Booking_RecordType::setTravel_Booking_File_Reference()
     * @uses Travel_Booking_RecordType::setTravel_Booking_Record_Data()
     * @param \StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param \StructType\Expense_StatusObjectType $expense_Status_Reference
     * @param \StructType\Travel_Booking_FileObjectType[] $travel_Booking_File_Reference
     * @param \StructType\Travel_Booking_Record_DataType[] $travel_Booking_Record_Data
     */
    public function __construct(\StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference = null, \StructType\Expense_ReportObjectType $expense_Report_Reference = null, \StructType\Expense_StatusObjectType $expense_Status_Reference = null, array $travel_Booking_File_Reference = array(), array $travel_Booking_Record_Data = array())
    {
        $this
            ->setTravel_Booking_Record_Reference($travel_Booking_Record_Reference)
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setExpense_Status_Reference($expense_Status_Reference)
            ->setTravel_Booking_File_Reference($travel_Booking_File_Reference)
            ->setTravel_Booking_Record_Data($travel_Booking_Record_Data);
    }
    /**
     * Get Travel_Booking_Record_Reference value
     * @return \StructType\Travel_Booking_RecordObjectType|null
     */
    public function getTravel_Booking_Record_Reference()
    {
        return $this->Travel_Booking_Record_Reference;
    }
    /**
     * Set Travel_Booking_Record_Reference value
     * @param \StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference
     * @return \StructType\Travel_Booking_RecordType
     */
    public function setTravel_Booking_Record_Reference(\StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference = null)
    {
        $this->Travel_Booking_Record_Reference = $travel_Booking_Record_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Travel_Booking_RecordType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get Expense_Status_Reference value
     * @return \StructType\Expense_StatusObjectType|null
     */
    public function getExpense_Status_Reference()
    {
        return $this->Expense_Status_Reference;
    }
    /**
     * Set Expense_Status_Reference value
     * @param \StructType\Expense_StatusObjectType $expense_Status_Reference
     * @return \StructType\Travel_Booking_RecordType
     */
    public function setExpense_Status_Reference(\StructType\Expense_StatusObjectType $expense_Status_Reference = null)
    {
        $this->Expense_Status_Reference = $expense_Status_Reference;
        return $this;
    }
    /**
     * Get Travel_Booking_File_Reference value
     * @return \StructType\Travel_Booking_FileObjectType[]|null
     */
    public function getTravel_Booking_File_Reference()
    {
        return $this->Travel_Booking_File_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_File_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_File_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_File_ReferenceForArrayConstraintsFromSetTravel_Booking_File_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem instanceof \StructType\Travel_Booking_FileObjectType) {
                $invalidValues[] = is_object($travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem) ? get_class($travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem), var_export($travel_Booking_RecordTypeTravel_Booking_File_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_File_Reference property can only contain items of type \StructType\Travel_Booking_FileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_FileObjectType[] $travel_Booking_File_Reference
     * @return \StructType\Travel_Booking_RecordType
     */
    public function setTravel_Booking_File_Reference(array $travel_Booking_File_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_File_ReferenceArrayErrorMessage = self::validateTravel_Booking_File_ReferenceForArrayConstraintsFromSetTravel_Booking_File_Reference($travel_Booking_File_Reference))) {
            throw new \InvalidArgumentException($travel_Booking_File_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_File_Reference = $travel_Booking_File_Reference;
        return $this;
    }
    /**
     * Add item to Travel_Booking_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_FileObjectType $item
     * @return \StructType\Travel_Booking_RecordType
     */
    public function addToTravel_Booking_File_Reference(\StructType\Travel_Booking_FileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_FileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_File_Reference property can only contain items of type \StructType\Travel_Booking_FileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_File_Reference[] = $item;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Data value
     * @return \StructType\Travel_Booking_Record_DataType[]|null
     */
    public function getTravel_Booking_Record_Data()
    {
        return $this->Travel_Booking_Record_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_Record_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_Record_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_Record_DataForArrayConstraintsFromSetTravel_Booking_Record_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_RecordTypeTravel_Booking_Record_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_RecordTypeTravel_Booking_Record_DataItem instanceof \StructType\Travel_Booking_Record_DataType) {
                $invalidValues[] = is_object($travel_Booking_RecordTypeTravel_Booking_Record_DataItem) ? get_class($travel_Booking_RecordTypeTravel_Booking_Record_DataItem) : sprintf('%s(%s)', gettype($travel_Booking_RecordTypeTravel_Booking_Record_DataItem), var_export($travel_Booking_RecordTypeTravel_Booking_Record_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_Record_Data property can only contain items of type \StructType\Travel_Booking_Record_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_Record_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_DataType[] $travel_Booking_Record_Data
     * @return \StructType\Travel_Booking_RecordType
     */
    public function setTravel_Booking_Record_Data(array $travel_Booking_Record_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_Record_DataArrayErrorMessage = self::validateTravel_Booking_Record_DataForArrayConstraintsFromSetTravel_Booking_Record_Data($travel_Booking_Record_Data))) {
            throw new \InvalidArgumentException($travel_Booking_Record_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_Record_Data = $travel_Booking_Record_Data;
        return $this;
    }
    /**
     * Add item to Travel_Booking_Record_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_DataType $item
     * @return \StructType\Travel_Booking_RecordType
     */
    public function addToTravel_Booking_Record_Data(\StructType\Travel_Booking_Record_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_Record_DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_Record_Data property can only contain items of type \StructType\Travel_Booking_Record_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_Record_Data[] = $item;
        return $this;
    }
}
