<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_Sheet_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains transfer pricing rate sheet instance and data based on the Request References or Request Criteria. The data returned is the current information as of the dates in the response filter, and does not include all historical
 * information about the transfer pricing rate sheet.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_Sheet_Response_DataType extends AbstractStructBase
{
    /**
     * The Transfer_Pricing_Rate_Sheet
     * Meta information extracted from the WSDL
     * - documentation: Contains transfer pricing rate sheet instance and data based on the Request References or Request Criteria.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transfer_Pricing_Rate_SheetType[]
     */
    public $Transfer_Pricing_Rate_Sheet;
    /**
     * Constructor method for Transfer_Pricing_Rate_Sheet_Response_DataType
     * @uses Transfer_Pricing_Rate_Sheet_Response_DataType::setTransfer_Pricing_Rate_Sheet()
     * @param \StructType\Transfer_Pricing_Rate_SheetType[] $transfer_Pricing_Rate_Sheet
     */
    public function __construct(array $transfer_Pricing_Rate_Sheet = array())
    {
        $this
            ->setTransfer_Pricing_Rate_Sheet($transfer_Pricing_Rate_Sheet);
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet value
     * @return \StructType\Transfer_Pricing_Rate_SheetType[]|null
     */
    public function getTransfer_Pricing_Rate_Sheet()
    {
        return $this->Transfer_Pricing_Rate_Sheet;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Pricing_Rate_Sheet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Pricing_Rate_Sheet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Pricing_Rate_SheetForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem) {
            // validation for constraint: itemType
            if (!$transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem instanceof \StructType\Transfer_Pricing_Rate_SheetType) {
                $invalidValues[] = is_object($transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem) ? get_class($transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem) : sprintf('%s(%s)', gettype($transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem), var_export($transfer_Pricing_Rate_Sheet_Response_DataTypeTransfer_Pricing_Rate_SheetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Pricing_Rate_Sheet property can only contain items of type \StructType\Transfer_Pricing_Rate_SheetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_SheetType[] $transfer_Pricing_Rate_Sheet
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Response_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet(array $transfer_Pricing_Rate_Sheet = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Pricing_Rate_SheetArrayErrorMessage = self::validateTransfer_Pricing_Rate_SheetForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet($transfer_Pricing_Rate_Sheet))) {
            throw new \InvalidArgumentException($transfer_Pricing_Rate_SheetArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet = $transfer_Pricing_Rate_Sheet;
        return $this;
    }
    /**
     * Add item to Transfer_Pricing_Rate_Sheet value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_SheetType $item
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Response_DataType
     */
    public function addToTransfer_Pricing_Rate_Sheet(\StructType\Transfer_Pricing_Rate_SheetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Pricing_Rate_SheetType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Pricing_Rate_Sheet property can only contain items of type \StructType\Transfer_Pricing_Rate_SheetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet[] = $item;
        return $this;
    }
}
