<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_Sheet_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains transfer pricing rate sheet details data based on the request parameters or submits data.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_Sheet_Detail_DataType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Transfer_Pricing_Rate_Sheet_Detail_ID
     * Meta information extracted from the WSDL
     * - documentation: ID value required for updates.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transfer_Pricing_Rate_Sheet_Detail_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Order
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Project_Cost_Rate_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Rate Rule
     * @var \StructType\Project_Cost_Rate_RuleObjectType
     */
    public $Project_Cost_Rate_Rule_Reference;
    /**
     * The Custom_Rate
     * Meta information extracted from the WSDL
     * - documentation: Retrieves or submits the hourly rate for transfer pricing cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 15
     * @var float
     */
    public $Custom_Rate;
    /**
     * The Rate_Percent_Markup
     * Meta information extracted from the WSDL
     * - documentation: Retrieves or submits the percentage associated with the transfer pricing cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Rate_Percent_Markup;
    /**
     * The Rate_Basis_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the transfer pricing rate basis, comprised of either the Custom Rate or the Standard Cost Rate Sheet. Required for the Put web service.
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Rate_Basis_Reference;
    /**
     * Constructor method for Transfer_Pricing_Rate_Sheet_Detail_DataType
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setDelete()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setTransfer_Pricing_Rate_Sheet_Detail_ID()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setOrder()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setProject_Cost_Rate_Rule_Reference()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setCustom_Rate()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setRate_Percent_Markup()
     * @uses Transfer_Pricing_Rate_Sheet_Detail_DataType::setRate_Basis_Reference()
     * @param bool $delete
     * @param string $transfer_Pricing_Rate_Sheet_Detail_ID
     * @param string $order
     * @param \StructType\Project_Cost_Rate_RuleObjectType $project_Cost_Rate_Rule_Reference
     * @param float $custom_Rate
     * @param float $rate_Percent_Markup
     * @param \StructType\Unique_IdentifierObjectType $rate_Basis_Reference
     */
    public function __construct($delete = null, $transfer_Pricing_Rate_Sheet_Detail_ID = null, $order = null, \StructType\Project_Cost_Rate_RuleObjectType $project_Cost_Rate_Rule_Reference = null, $custom_Rate = null, $rate_Percent_Markup = null, \StructType\Unique_IdentifierObjectType $rate_Basis_Reference = null)
    {
        $this
            ->setDelete($delete)
            ->setTransfer_Pricing_Rate_Sheet_Detail_ID($transfer_Pricing_Rate_Sheet_Detail_ID)
            ->setOrder($order)
            ->setProject_Cost_Rate_Rule_Reference($project_Cost_Rate_Rule_Reference)
            ->setCustom_Rate($custom_Rate)
            ->setRate_Percent_Markup($rate_Percent_Markup)
            ->setRate_Basis_Reference($rate_Basis_Reference);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Detail_ID value
     * @return string|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Detail_ID()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Detail_ID;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Detail_ID value
     * @param string $transfer_Pricing_Rate_Sheet_Detail_ID
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet_Detail_ID($transfer_Pricing_Rate_Sheet_Detail_ID = null)
    {
        // validation for constraint: string
        if (!is_null($transfer_Pricing_Rate_Sheet_Detail_ID) && !is_string($transfer_Pricing_Rate_Sheet_Detail_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transfer_Pricing_Rate_Sheet_Detail_ID, true), gettype($transfer_Pricing_Rate_Sheet_Detail_ID)), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Detail_ID = $transfer_Pricing_Rate_Sheet_Detail_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Project_Cost_Rate_Rule_Reference value
     * @return \StructType\Project_Cost_Rate_RuleObjectType|null
     */
    public function getProject_Cost_Rate_Rule_Reference()
    {
        return $this->Project_Cost_Rate_Rule_Reference;
    }
    /**
     * Set Project_Cost_Rate_Rule_Reference value
     * @param \StructType\Project_Cost_Rate_RuleObjectType $project_Cost_Rate_Rule_Reference
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setProject_Cost_Rate_Rule_Reference(\StructType\Project_Cost_Rate_RuleObjectType $project_Cost_Rate_Rule_Reference = null)
    {
        $this->Project_Cost_Rate_Rule_Reference = $project_Cost_Rate_Rule_Reference;
        return $this;
    }
    /**
     * Get Custom_Rate value
     * @return float|null
     */
    public function getCustom_Rate()
    {
        return $this->Custom_Rate;
    }
    /**
     * Set Custom_Rate value
     * @param float $custom_Rate
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setCustom_Rate($custom_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($custom_Rate) && !(is_float($custom_Rate) || is_numeric($custom_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($custom_Rate, true), gettype($custom_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($custom_Rate) && mb_strlen(mb_substr($custom_Rate, false !== mb_strpos($custom_Rate, '.') ? mb_strpos($custom_Rate, '.') + 1 : mb_strlen($custom_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($custom_Rate, true), mb_strlen(mb_substr($custom_Rate, mb_strpos($custom_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($custom_Rate) && mb_strlen(preg_replace('/(\D)/', '', $custom_Rate)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($custom_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $custom_Rate))), __LINE__);
        }
        $this->Custom_Rate = $custom_Rate;
        return $this;
    }
    /**
     * Get Rate_Percent_Markup value
     * @return float|null
     */
    public function getRate_Percent_Markup()
    {
        return $this->Rate_Percent_Markup;
    }
    /**
     * Set Rate_Percent_Markup value
     * @param float $rate_Percent_Markup
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setRate_Percent_Markup($rate_Percent_Markup = null)
    {
        // validation for constraint: float
        if (!is_null($rate_Percent_Markup) && !(is_float($rate_Percent_Markup) || is_numeric($rate_Percent_Markup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate_Percent_Markup, true), gettype($rate_Percent_Markup)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($rate_Percent_Markup) && mb_strlen(mb_substr($rate_Percent_Markup, false !== mb_strpos($rate_Percent_Markup, '.') ? mb_strpos($rate_Percent_Markup, '.') + 1 : mb_strlen($rate_Percent_Markup))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($rate_Percent_Markup, true), mb_strlen(mb_substr($rate_Percent_Markup, mb_strpos($rate_Percent_Markup, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($rate_Percent_Markup) && mb_strlen(preg_replace('/(\D)/', '', $rate_Percent_Markup)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($rate_Percent_Markup, true), mb_strlen(preg_replace('/(\D)/', '', $rate_Percent_Markup))), __LINE__);
        }
        $this->Rate_Percent_Markup = $rate_Percent_Markup;
        return $this;
    }
    /**
     * Get Rate_Basis_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getRate_Basis_Reference()
    {
        return $this->Rate_Basis_Reference;
    }
    /**
     * Set Rate_Basis_Reference value
     * @param \StructType\Unique_IdentifierObjectType $rate_Basis_Reference
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType
     */
    public function setRate_Basis_Reference(\StructType\Unique_IdentifierObjectType $rate_Basis_Reference = null)
    {
        $this->Rate_Basis_Reference = $rate_Basis_Reference;
        return $this;
    }
}
