<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Tax Information
 * @subpackage Structs
 */
class Tax_Widget_DataType extends AbstractStructBase
{
    /**
     * The Tax_Point_Date_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Point Date Type
     * - minOccurs: 0
     * @var \StructType\Tax_Point_Date_TypeObjectType
     */
    public $Tax_Point_Date_Type_Reference;
    /**
     * The Tax_Point_Date
     * Meta information extracted from the WSDL
     * - documentation: Tax Point Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax_Point_Date;
    /**
     * Constructor method for Tax_Widget_DataType
     * @uses Tax_Widget_DataType::setTax_Point_Date_Type_Reference()
     * @uses Tax_Widget_DataType::setTax_Point_Date()
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @param string $tax_Point_Date
     */
    public function __construct(\StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null, $tax_Point_Date = null)
    {
        $this
            ->setTax_Point_Date_Type_Reference($tax_Point_Date_Type_Reference)
            ->setTax_Point_Date($tax_Point_Date);
    }
    /**
     * Get Tax_Point_Date_Type_Reference value
     * @return \StructType\Tax_Point_Date_TypeObjectType|null
     */
    public function getTax_Point_Date_Type_Reference()
    {
        return $this->Tax_Point_Date_Type_Reference;
    }
    /**
     * Set Tax_Point_Date_Type_Reference value
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @return \StructType\Tax_Widget_DataType
     */
    public function setTax_Point_Date_Type_Reference(\StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null)
    {
        $this->Tax_Point_Date_Type_Reference = $tax_Point_Date_Type_Reference;
        return $this;
    }
    /**
     * Get Tax_Point_Date value
     * @return string|null
     */
    public function getTax_Point_Date()
    {
        return $this->Tax_Point_Date;
    }
    /**
     * Set Tax_Point_Date value
     * @param string $tax_Point_Date
     * @return \StructType\Tax_Widget_DataType
     */
    public function setTax_Point_Date($tax_Point_Date = null)
    {
        // validation for constraint: string
        if (!is_null($tax_Point_Date) && !is_string($tax_Point_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_Point_Date, true), gettype($tax_Point_Date)), __LINE__);
        }
        $this->Tax_Point_Date = $tax_Point_Date;
        return $this;
    }
}
