<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Reference element contains the specific instance set containing the requested Supplier. The ID is either the Lookup ID or the Workday ID (GUID).
 * @subpackage Structs
 */
class Supplier_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - maxOccurs: unbounded
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * Constructor method for Supplier_Request_ReferencesType
     * @uses Supplier_Request_ReferencesType::setSupplier_Reference()
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     */
    public function __construct(array $supplier_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Request_ReferencesTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Request_ReferencesTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_Request_ReferencesTypeSupplier_ReferenceItem) ? get_class($supplier_Request_ReferencesTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Request_ReferencesTypeSupplier_ReferenceItem), var_export($supplier_Request_ReferencesTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Request_ReferencesType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_Request_ReferencesType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
}
