<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Price_Update_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request reference and response group for getting Supplier Item Price Update data
 * @subpackage Structs
 */
class Supplier_Item_Price_Update_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference for the import. Important:For integration systems where we want to limit updates to only a single supplier, this should be a required field and singular and defaulted by the integration system to only be the exact
     * supplier that the user has permission to update pricing. Note that if this is provided, all supplier item updates will need to be for the same supplier.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Import_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the request
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Import_Memo;
    /**
     * The Supplier_Item_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Price_Update__HV__DataType[]
     */
    public $Supplier_Item_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Supplier_Item_Price_Update_RequestType
     * @uses Supplier_Item_Price_Update_RequestType::setBusiness_Process_Parameters()
     * @uses Supplier_Item_Price_Update_RequestType::setSupplier_Reference()
     * @uses Supplier_Item_Price_Update_RequestType::setImport_Memo()
     * @uses Supplier_Item_Price_Update_RequestType::setSupplier_Item_Data()
     * @uses Supplier_Item_Price_Update_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param string $import_Memo
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType[] $supplier_Item_Data
     * @param string $version
     */
    public function __construct(array $business_Process_Parameters = array(), \StructType\SupplierObjectType $supplier_Reference = null, $import_Memo = null, array $supplier_Item_Data = array(), $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Reference($supplier_Reference)
            ->setImport_Memo($import_Memo)
            ->setSupplier_Item_Data($supplier_Item_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem) ? get_class($supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem), var_export($supplier_Item_Price_Update_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Import_Memo value
     * @return string|null
     */
    public function getImport_Memo()
    {
        return $this->Import_Memo;
    }
    /**
     * Set Import_Memo value
     * @param string $import_Memo
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function setImport_Memo($import_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($import_Memo) && !is_string($import_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($import_Memo, true), gettype($import_Memo)), __LINE__);
        }
        $this->Import_Memo = $import_Memo;
        return $this;
    }
    /**
     * Get Supplier_Item_Data value
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType[]|null
     */
    public function getSupplier_Item_Data()
    {
        return $this->Supplier_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem instanceof \StructType\Supplier_Item_Price_Update__HV__DataType) {
                $invalidValues[] = is_object($supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem) ? get_class($supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem) : sprintf('%s(%s)', gettype($supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem), var_export($supplier_Item_Price_Update_RequestTypeSupplier_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Supplier_Item_Price_Update__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType[] $supplier_Item_Data
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function setSupplier_Item_Data(array $supplier_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_DataArrayErrorMessage = self::validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data($supplier_Item_Data))) {
            throw new \InvalidArgumentException($supplier_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Data = $supplier_Item_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType $item
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function addToSupplier_Item_Data(\StructType\Supplier_Item_Price_Update__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Price_Update__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Supplier_Item_Price_Update__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Supplier_Item_Price_Update_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
