<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_TagType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Work Queue Tag Instance and Data
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_TagType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplier invoice work queue tag
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_TagObjectType
     */
    public $Supplier_Invoice_Work_Queue_Tag_Reference;
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier invoice work queue tag data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Tag_DataType[]
     */
    public $Supplier_Invoice_Work_Queue_Tag_Data;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_TagType
     * @uses Supplier_Invoice_Work_Queue_TagType::setSupplier_Invoice_Work_Queue_Tag_Reference()
     * @uses Supplier_Invoice_Work_Queue_TagType::setSupplier_Invoice_Work_Queue_Tag_Data()
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_DataType[] $supplier_Invoice_Work_Queue_Tag_Data
     */
    public function __construct(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference = null, array $supplier_Invoice_Work_Queue_Tag_Data = array())
    {
        $this
            ->setSupplier_Invoice_Work_Queue_Tag_Reference($supplier_Invoice_Work_Queue_Tag_Reference)
            ->setSupplier_Invoice_Work_Queue_Tag_Data($supplier_Invoice_Work_Queue_Tag_Data);
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagObjectType|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Reference()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Reference;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Reference value
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_TagType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Reference(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference = null)
    {
        $this->Supplier_Invoice_Work_Queue_Tag_Reference = $supplier_Invoice_Work_Queue_Tag_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Data value
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType[]|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Data()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Work_Queue_Tag_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Work_Queue_Tag_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Work_Queue_Tag_DataForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem instanceof \StructType\Supplier_Invoice_Work_Queue_Tag_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem) ? get_class($supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem), var_export($supplier_Invoice_Work_Queue_TagTypeSupplier_Invoice_Work_Queue_Tag_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Work_Queue_Tag_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Tag_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_DataType[] $supplier_Invoice_Work_Queue_Tag_Data
     * @return \StructType\Supplier_Invoice_Work_Queue_TagType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Data(array $supplier_Invoice_Work_Queue_Tag_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Work_Queue_Tag_DataArrayErrorMessage = self::validateSupplier_Invoice_Work_Queue_Tag_DataForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Data($supplier_Invoice_Work_Queue_Tag_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Work_Queue_Tag_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Data = $supplier_Invoice_Work_Queue_Tag_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Work_Queue_Tag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_DataType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_TagType
     */
    public function addToSupplier_Invoice_Work_Queue_Tag_Data(\StructType\Supplier_Invoice_Work_Queue_Tag_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_Tag_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Work_Queue_Tag_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Tag_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Data[] = $item;
        return $this;
    }
}
