<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Invoice Schedule Data
 * @subpackage Structs
 */
class Supplier_Invoice_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Schedule_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Schedule Reference ID. This is the Supplier Invoice Schedule unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Schedule_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit flag. The service will attempt to submit the schedule if this is on.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Schedule_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Schedule Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Schedule_Status_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule supplier.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - choice: Supplier_Connection_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Use_Default_Supplier_Connection
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the default supplier connection will be derived.
     * - choice: Supplier_Connection_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Default_Supplier_Connection;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Statutory_Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Statutory Invoice Type for Supplier Invoice Schedule.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Statutory_Invoice_Type_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule supplier contract.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Supplier_Contract_Lines_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is a reference to an existing Supplier Contract Line that isn't used by another Supplier Contract type Schedule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Installment_ItemObjectType[]
     */
    public $Supplier_Contract_Lines_Reference;
    /**
     * The Schedule_Description
     * Meta information extracted from the WSDL
     * - documentation: Schedule Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule_Description;
    /**
     * The Schedule_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Schedule On Hold flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Schedule_On_Hold;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't submit a Tax Code when the Company has a third party tax integration enabled for Supplier Invoices. | You can't specify a third party tax code in the transaction tax code reference. | Default Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Payment Terms.
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the override Supplier Invoice Payment Type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Auto_submit_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Auto-Submit Invoices for Approval flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_submit_for_Approval;
    /**
     * The Supplier_Invoice_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Reference_Number;
    /**
     * The Distribution_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Contract type Schedule Distribution Method. Valid values are: - Custom (CUSTOM). - Defined Installment (RECURRING). - Spread Even (EVEN).
     * - minOccurs: 0
     * @var \StructType\Schedule_Distribution_MethodObjectType
     */
    public $Distribution_Method_Reference;
    /**
     * The Distribute_by_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Distribute by Quantity Flag. Use this flag to distribute the Schedule Installments by Quantity instead of by Amount.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Distribute_by_Quantity;
    /**
     * The Frequency__Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule Installment Frequency.
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency__Reference;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: From date. The system generates installments based on this value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The To_Date
     * Meta information extracted from the WSDL
     * - documentation: To date. The system generates installments based on this value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Date;
    /**
     * The Number_of_Installments
     * Meta information extracted from the WSDL
     * - documentation: Number of installments. The system generates installments based on this value. | The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Installments;
    /**
     * The Date_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Date Option used for Installment generation. Valid values are: - Contract Line Start Date (LINE_START). - Contract Signed Date (CONTRACT_SIGNED). - Contract Start Date (CONTRACT_START). - Receipt Date (RECEIPT). -
     * Use From Date (SCHEDULE_FROM_DATE). - Use To Date (SCHEDULE_TO_DATE).
     * - minOccurs: 0
     * @var \StructType\Procurement_Date_OptionObjectType
     */
    public $Date_Option_Reference;
    /**
     * The Day_of_Month
     * Meta information extracted from the WSDL
     * - documentation: Day of Month. The system generates installments based on this value.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Day_of_Month;
    /**
     * The Automatically_Regenerate_Installments
     * Meta information extracted from the WSDL
     * - documentation: Automatically Regenerate Installments Flag. Use this flag to Regenerate installments when Supplier Contract Amendments are completed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Regenerate_Installments;
    /**
     * The Automatically_Submit_Schedules
     * Meta information extracted from the WSDL
     * - documentation: Automatically Submit Schedules Flag. Use this flag when automatically regenerating installments when Supplier Contract Amendments are completed to automatically submit the Supplier Contract type Schedule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Submit_Schedules;
    /**
     * The System_Generated
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Supplier Invoice Schedule was System Generated. Not enterable for Submit Supplier Invoice Schedule web service. It is used only by Get Supplier Invoice Schedule web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $System_Generated;
    /**
     * The Supplier_Invoice_Installment_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Installment_Replacement_DataType[]
     */
    public $Supplier_Invoice_Installment_Replacement_Data;
    /**
     * Constructor method for Supplier_Invoice_Schedule_DataType
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Invoice_Schedule_ID()
     * @uses Supplier_Invoice_Schedule_DataType::setSubmit()
     * @uses Supplier_Invoice_Schedule_DataType::setSchedule_Status_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setCompany_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Connection_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setUse_Default_Supplier_Connection()
     * @uses Supplier_Invoice_Schedule_DataType::setCurrency_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setStatutory_Invoice_Type_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Contract_Lines_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setSchedule_Description()
     * @uses Supplier_Invoice_Schedule_DataType::setSchedule_On_Hold()
     * @uses Supplier_Invoice_Schedule_DataType::setTax_Code_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setOverride_Payment_Type_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setAuto_submit_for_Approval()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Invoice_Reference_Number()
     * @uses Supplier_Invoice_Schedule_DataType::setDistribution_Method_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setDistribute_by_Quantity()
     * @uses Supplier_Invoice_Schedule_DataType::setFrequency__Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setFrom_Date()
     * @uses Supplier_Invoice_Schedule_DataType::setTo_Date()
     * @uses Supplier_Invoice_Schedule_DataType::setNumber_of_Installments()
     * @uses Supplier_Invoice_Schedule_DataType::setDate_Option_Reference()
     * @uses Supplier_Invoice_Schedule_DataType::setDay_of_Month()
     * @uses Supplier_Invoice_Schedule_DataType::setAutomatically_Regenerate_Installments()
     * @uses Supplier_Invoice_Schedule_DataType::setAutomatically_Submit_Schedules()
     * @uses Supplier_Invoice_Schedule_DataType::setSystem_Generated()
     * @uses Supplier_Invoice_Schedule_DataType::setSupplier_Invoice_Installment_Replacement_Data()
     * @param string $supplier_Invoice_Schedule_ID
     * @param bool $submit
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param bool $use_Default_Supplier_Connection
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Installment_ItemObjectType[] $supplier_Contract_Lines_Reference
     * @param string $schedule_Description
     * @param bool $schedule_On_Hold
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param bool $auto_submit_for_Approval
     * @param string $supplier_Invoice_Reference_Number
     * @param \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference
     * @param bool $distribute_by_Quantity
     * @param \StructType\Frequency_BehaviorObjectType $frequency__Reference
     * @param string $from_Date
     * @param string $to_Date
     * @param float $number_of_Installments
     * @param \StructType\Procurement_Date_OptionObjectType $date_Option_Reference
     * @param float $day_of_Month
     * @param bool $automatically_Regenerate_Installments
     * @param bool $automatically_Submit_Schedules
     * @param bool $system_Generated
     * @param \StructType\Supplier_Invoice_Installment_Replacement_DataType[] $supplier_Invoice_Installment_Replacement_Data
     */
    public function __construct($supplier_Invoice_Schedule_ID = null, $submit = null, array $schedule_Status_Reference = array(), \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $use_Default_Supplier_Connection = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $supplier_Contract_Lines_Reference = array(), $schedule_Description = null, $schedule_On_Hold = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, $auto_submit_for_Approval = null, $supplier_Invoice_Reference_Number = null, \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference = null, $distribute_by_Quantity = null, \StructType\Frequency_BehaviorObjectType $frequency__Reference = null, $from_Date = null, $to_Date = null, $number_of_Installments = null, \StructType\Procurement_Date_OptionObjectType $date_Option_Reference = null, $day_of_Month = null, $automatically_Regenerate_Installments = null, $automatically_Submit_Schedules = null, $system_Generated = null, array $supplier_Invoice_Installment_Replacement_Data = array())
    {
        $this
            ->setSupplier_Invoice_Schedule_ID($supplier_Invoice_Schedule_ID)
            ->setSubmit($submit)
            ->setSchedule_Status_Reference($schedule_Status_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setUse_Default_Supplier_Connection($use_Default_Supplier_Connection)
            ->setCurrency_Reference($currency_Reference)
            ->setStatutory_Invoice_Type_Reference($statutory_Invoice_Type_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setSupplier_Contract_Lines_Reference($supplier_Contract_Lines_Reference)
            ->setSchedule_Description($schedule_Description)
            ->setSchedule_On_Hold($schedule_On_Hold)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setAuto_submit_for_Approval($auto_submit_for_Approval)
            ->setSupplier_Invoice_Reference_Number($supplier_Invoice_Reference_Number)
            ->setDistribution_Method_Reference($distribution_Method_Reference)
            ->setDistribute_by_Quantity($distribute_by_Quantity)
            ->setFrequency__Reference($frequency__Reference)
            ->setFrom_Date($from_Date)
            ->setTo_Date($to_Date)
            ->setNumber_of_Installments($number_of_Installments)
            ->setDate_Option_Reference($date_Option_Reference)
            ->setDay_of_Month($day_of_Month)
            ->setAutomatically_Regenerate_Installments($automatically_Regenerate_Installments)
            ->setAutomatically_Submit_Schedules($automatically_Submit_Schedules)
            ->setSystem_Generated($system_Generated)
            ->setSupplier_Invoice_Installment_Replacement_Data($supplier_Invoice_Installment_Replacement_Data);
    }
    /**
     * Get Supplier_Invoice_Schedule_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Schedule_ID()
    {
        return $this->Supplier_Invoice_Schedule_ID;
    }
    /**
     * Set Supplier_Invoice_Schedule_ID value
     * @param string $supplier_Invoice_Schedule_ID
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Invoice_Schedule_ID($supplier_Invoice_Schedule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Schedule_ID) && !is_string($supplier_Invoice_Schedule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Schedule_ID, true), gettype($supplier_Invoice_Schedule_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Schedule_ID = $supplier_Invoice_Schedule_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Schedule_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getSchedule_Status_Reference()
    {
        return $this->Schedule_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedule_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedule_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem) ? get_class($supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem), var_export($supplier_Invoice_Schedule_DataTypeSchedule_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSchedule_Status_Reference(array $schedule_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($schedule_Status_ReferenceArrayErrorMessage = self::validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference($schedule_Status_Reference))) {
            throw new \InvalidArgumentException($schedule_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Schedule_Status_Reference = $schedule_Status_Reference;
        return $this;
    }
    /**
     * Add item to Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function addToSchedule_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedule_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return isset($this->Supplier_Connection_Reference) ? $this->Supplier_Connection_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Connection_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Default_Supplier_Connection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Connection_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Connection_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Connection_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        // validation for constraint: choice(Supplier_Connection_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($supplier_Connection_ReferenceChoiceErrorMessage = self::validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($supplier_Connection_Reference))) {
            throw new \InvalidArgumentException($supplier_Connection_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Connection_Reference) || (is_array($supplier_Connection_Reference) && empty($supplier_Connection_Reference))) {
            unset($this->Supplier_Connection_Reference);
        } else {
            $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        }
        return $this;
    }
    /**
     * Get Use_Default_Supplier_Connection value
     * @return bool|null
     */
    public function getUse_Default_Supplier_Connection()
    {
        return isset($this->Use_Default_Supplier_Connection) ? $this->Use_Default_Supplier_Connection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Default_Supplier_Connection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Default_Supplier_Connection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Connection_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Default_Supplier_Connection can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Default_Supplier_Connection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Default_Supplier_Connection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Default_Supplier_Connection
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setUse_Default_Supplier_Connection($use_Default_Supplier_Connection = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Default_Supplier_Connection) && !is_bool($use_Default_Supplier_Connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Default_Supplier_Connection, true), gettype($use_Default_Supplier_Connection)), __LINE__);
        }
        // validation for constraint: choice(Supplier_Connection_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($use_Default_Supplier_ConnectionChoiceErrorMessage = self::validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($use_Default_Supplier_Connection))) {
            throw new \InvalidArgumentException($use_Default_Supplier_ConnectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Default_Supplier_Connection) || (is_array($use_Default_Supplier_Connection) && empty($use_Default_Supplier_Connection))) {
            unset($this->Use_Default_Supplier_Connection);
        } else {
            $this->Use_Default_Supplier_Connection = $use_Default_Supplier_Connection;
        }
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Statutory_Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getStatutory_Invoice_Type_Reference()
    {
        return $this->Statutory_Invoice_Type_Reference;
    }
    /**
     * Set Statutory_Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setStatutory_Invoice_Type_Reference(\StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null)
    {
        $this->Statutory_Invoice_Type_Reference = $statutory_Invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Lines_Reference value
     * @return \StructType\Installment_ItemObjectType[]|null
     */
    public function getSupplier_Contract_Lines_Reference()
    {
        return $this->Supplier_Contract_Lines_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Lines_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Lines_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Lines_ReferenceForArrayConstraintsFromSetSupplier_Contract_Lines_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem instanceof \StructType\Installment_ItemObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) ? get_class($supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem), var_export($supplier_Invoice_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Lines_Reference property can only contain items of type \StructType\Installment_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment_ItemObjectType[] $supplier_Contract_Lines_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Contract_Lines_Reference(array $supplier_Contract_Lines_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Lines_ReferenceArrayErrorMessage = self::validateSupplier_Contract_Lines_ReferenceForArrayConstraintsFromSetSupplier_Contract_Lines_Reference($supplier_Contract_Lines_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_Lines_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Lines_Reference = $supplier_Contract_Lines_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment_ItemObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function addToSupplier_Contract_Lines_Reference(\StructType\Installment_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Installment_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Lines_Reference property can only contain items of type \StructType\Installment_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Lines_Reference[] = $item;
        return $this;
    }
    /**
     * Get Schedule_Description value
     * @return string|null
     */
    public function getSchedule_Description()
    {
        return $this->Schedule_Description;
    }
    /**
     * Set Schedule_Description value
     * @param string $schedule_Description
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSchedule_Description($schedule_Description = null)
    {
        // validation for constraint: string
        if (!is_null($schedule_Description) && !is_string($schedule_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule_Description, true), gettype($schedule_Description)), __LINE__);
        }
        $this->Schedule_Description = $schedule_Description;
        return $this;
    }
    /**
     * Get Schedule_On_Hold value
     * @return bool|null
     */
    public function getSchedule_On_Hold()
    {
        return $this->Schedule_On_Hold;
    }
    /**
     * Set Schedule_On_Hold value
     * @param bool $schedule_On_Hold
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSchedule_On_Hold($schedule_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($schedule_On_Hold) && !is_bool($schedule_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schedule_On_Hold, true), gettype($schedule_On_Hold)), __LINE__);
        }
        $this->Schedule_On_Hold = $schedule_On_Hold;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Auto_submit_for_Approval value
     * @return bool|null
     */
    public function getAuto_submit_for_Approval()
    {
        return $this->{'Auto-submit_for_Approval'};
    }
    /**
     * Set Auto_submit_for_Approval value
     * @param bool $auto_submit_for_Approval
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setAuto_submit_for_Approval($auto_submit_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_submit_for_Approval) && !is_bool($auto_submit_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_submit_for_Approval, true), gettype($auto_submit_for_Approval)), __LINE__);
        }
        $this->Auto_submit_for_Approval = $this->{'Auto-submit_for_Approval'} = $auto_submit_for_Approval;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Reference_Number()
    {
        return $this->Supplier_Invoice_Reference_Number;
    }
    /**
     * Set Supplier_Invoice_Reference_Number value
     * @param string $supplier_Invoice_Reference_Number
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Invoice_Reference_Number($supplier_Invoice_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Reference_Number) && !is_string($supplier_Invoice_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Reference_Number, true), gettype($supplier_Invoice_Reference_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Reference_Number = $supplier_Invoice_Reference_Number;
        return $this;
    }
    /**
     * Get Distribution_Method_Reference value
     * @return \StructType\Schedule_Distribution_MethodObjectType|null
     */
    public function getDistribution_Method_Reference()
    {
        return $this->Distribution_Method_Reference;
    }
    /**
     * Set Distribution_Method_Reference value
     * @param \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setDistribution_Method_Reference(\StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference = null)
    {
        $this->Distribution_Method_Reference = $distribution_Method_Reference;
        return $this;
    }
    /**
     * Get Distribute_by_Quantity value
     * @return bool|null
     */
    public function getDistribute_by_Quantity()
    {
        return $this->Distribute_by_Quantity;
    }
    /**
     * Set Distribute_by_Quantity value
     * @param bool $distribute_by_Quantity
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setDistribute_by_Quantity($distribute_by_Quantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($distribute_by_Quantity) && !is_bool($distribute_by_Quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($distribute_by_Quantity, true), gettype($distribute_by_Quantity)), __LINE__);
        }
        $this->Distribute_by_Quantity = $distribute_by_Quantity;
        return $this;
    }
    /**
     * Get Frequency__Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency__Reference()
    {
        return $this->Frequency__Reference;
    }
    /**
     * Set Frequency__Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency__Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setFrequency__Reference(\StructType\Frequency_BehaviorObjectType $frequency__Reference = null)
    {
        $this->Frequency__Reference = $frequency__Reference;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get To_Date value
     * @return string|null
     */
    public function getTo_Date()
    {
        return $this->To_Date;
    }
    /**
     * Set To_Date value
     * @param string $to_Date
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setTo_Date($to_Date = null)
    {
        // validation for constraint: string
        if (!is_null($to_Date) && !is_string($to_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Date, true), gettype($to_Date)), __LINE__);
        }
        $this->To_Date = $to_Date;
        return $this;
    }
    /**
     * Get Number_of_Installments value
     * @return float|null
     */
    public function getNumber_of_Installments()
    {
        return $this->Number_of_Installments;
    }
    /**
     * Set Number_of_Installments value
     * @param float $number_of_Installments
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setNumber_of_Installments($number_of_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Installments) && !(is_float($number_of_Installments) || is_numeric($number_of_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Installments, true), gettype($number_of_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Installments) && mb_strlen(mb_substr($number_of_Installments, false !== mb_strpos($number_of_Installments, '.') ? mb_strpos($number_of_Installments, '.') + 1 : mb_strlen($number_of_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Installments, true), mb_strlen(mb_substr($number_of_Installments, mb_strpos($number_of_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Installments) && $number_of_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments))), __LINE__);
        }
        $this->Number_of_Installments = $number_of_Installments;
        return $this;
    }
    /**
     * Get Date_Option_Reference value
     * @return \StructType\Procurement_Date_OptionObjectType|null
     */
    public function getDate_Option_Reference()
    {
        return $this->Date_Option_Reference;
    }
    /**
     * Set Date_Option_Reference value
     * @param \StructType\Procurement_Date_OptionObjectType $date_Option_Reference
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setDate_Option_Reference(\StructType\Procurement_Date_OptionObjectType $date_Option_Reference = null)
    {
        $this->Date_Option_Reference = $date_Option_Reference;
        return $this;
    }
    /**
     * Get Day_of_Month value
     * @return float|null
     */
    public function getDay_of_Month()
    {
        return $this->Day_of_Month;
    }
    /**
     * Set Day_of_Month value
     * @param float $day_of_Month
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setDay_of_Month($day_of_Month = null)
    {
        // validation for constraint: float
        if (!is_null($day_of_Month) && !(is_float($day_of_Month) || is_numeric($day_of_Month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($day_of_Month, true), gettype($day_of_Month)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($day_of_Month) && mb_strlen(mb_substr($day_of_Month, false !== mb_strpos($day_of_Month, '.') ? mb_strpos($day_of_Month, '.') + 1 : mb_strlen($day_of_Month))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($day_of_Month, true), mb_strlen(mb_substr($day_of_Month, mb_strpos($day_of_Month, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($day_of_Month) && $day_of_Month < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($day_of_Month, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($day_of_Month) && mb_strlen(preg_replace('/(\D)/', '', $day_of_Month)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($day_of_Month, true), mb_strlen(preg_replace('/(\D)/', '', $day_of_Month))), __LINE__);
        }
        $this->Day_of_Month = $day_of_Month;
        return $this;
    }
    /**
     * Get Automatically_Regenerate_Installments value
     * @return bool|null
     */
    public function getAutomatically_Regenerate_Installments()
    {
        return $this->Automatically_Regenerate_Installments;
    }
    /**
     * Set Automatically_Regenerate_Installments value
     * @param bool $automatically_Regenerate_Installments
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setAutomatically_Regenerate_Installments($automatically_Regenerate_Installments = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Regenerate_Installments) && !is_bool($automatically_Regenerate_Installments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Regenerate_Installments, true), gettype($automatically_Regenerate_Installments)), __LINE__);
        }
        $this->Automatically_Regenerate_Installments = $automatically_Regenerate_Installments;
        return $this;
    }
    /**
     * Get Automatically_Submit_Schedules value
     * @return bool|null
     */
    public function getAutomatically_Submit_Schedules()
    {
        return $this->Automatically_Submit_Schedules;
    }
    /**
     * Set Automatically_Submit_Schedules value
     * @param bool $automatically_Submit_Schedules
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setAutomatically_Submit_Schedules($automatically_Submit_Schedules = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Submit_Schedules) && !is_bool($automatically_Submit_Schedules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Submit_Schedules, true), gettype($automatically_Submit_Schedules)), __LINE__);
        }
        $this->Automatically_Submit_Schedules = $automatically_Submit_Schedules;
        return $this;
    }
    /**
     * Get System_Generated value
     * @return bool|null
     */
    public function getSystem_Generated()
    {
        return $this->System_Generated;
    }
    /**
     * Set System_Generated value
     * @param bool $system_Generated
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSystem_Generated($system_Generated = null)
    {
        // validation for constraint: boolean
        if (!is_null($system_Generated) && !is_bool($system_Generated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($system_Generated, true), gettype($system_Generated)), __LINE__);
        }
        $this->System_Generated = $system_Generated;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Installment_Replacement_Data value
     * @return \StructType\Supplier_Invoice_Installment_Replacement_DataType[]|null
     */
    public function getSupplier_Invoice_Installment_Replacement_Data()
    {
        return $this->Supplier_Invoice_Installment_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Installment_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Installment_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Installment_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Installment_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem instanceof \StructType\Supplier_Invoice_Installment_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem) ? get_class($supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem), var_export($supplier_Invoice_Schedule_DataTypeSupplier_Invoice_Installment_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Installment_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Installment_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Installment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Installment_Replacement_DataType[] $supplier_Invoice_Installment_Replacement_Data
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function setSupplier_Invoice_Installment_Replacement_Data(array $supplier_Invoice_Installment_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Installment_Replacement_DataArrayErrorMessage = self::validateSupplier_Invoice_Installment_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Installment_Replacement_Data($supplier_Invoice_Installment_Replacement_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Installment_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Installment_Replacement_Data = $supplier_Invoice_Installment_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Installment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Installment_Replacement_DataType $item
     * @return \StructType\Supplier_Invoice_Schedule_DataType
     */
    public function addToSupplier_Invoice_Installment_Replacement_Data(\StructType\Supplier_Invoice_Installment_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Installment_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Installment_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Installment_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Installment_Replacement_Data[] = $item;
        return $this;
    }
}
