<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Request_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Invoice Request request criteria
 * @subpackage Structs
 */
class Supplier_Invoice_Request_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Invoice_Request_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Invoice Request Document Status. Examples of Document Status are Approved, Canceled and In Progress
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Invoice_Request_Status_Reference;
    /**
     * The Invoice_Request_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Request_Date_On_or_After;
    /**
     * The Invoice_Request_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Request_Date_On_or_Before;
    /**
     * The Invoice_Request_Due_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Invoice Due Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Request_Due_Date_On_or_After;
    /**
     * The Invoice_Request_Due_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Invoice Due Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Request_Due_Date_On_or_Before;
    /**
     * The Created_by_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker who created the transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Created_by_Worker_Reference;
    /**
     * The Approved_by_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker who approved the invoice request
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approved_by_Worker_Reference;
    /**
     * Constructor method for Supplier_Invoice_Request_Request_CriteriaType
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setInvoice_Request_Status_Reference()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setInvoice_Request_Date_On_or_After()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setInvoice_Request_Date_On_or_Before()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setInvoice_Request_Due_Date_On_or_After()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setInvoice_Request_Due_Date_On_or_Before()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setCreated_by_Worker_Reference()
     * @uses Supplier_Invoice_Request_Request_CriteriaType::setApproved_by_Worker_Reference()
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Document_StatusObjectType[] $invoice_Request_Status_Reference
     * @param string $invoice_Request_Date_On_or_After
     * @param string $invoice_Request_Date_On_or_Before
     * @param string $invoice_Request_Due_Date_On_or_After
     * @param string $invoice_Request_Due_Date_On_or_Before
     * @param \StructType\WorkerObjectType[] $created_by_Worker_Reference
     * @param \StructType\WorkerObjectType[] $approved_by_Worker_Reference
     */
    public function __construct(array $supplier_Reference = array(), array $company_Reference = array(), array $invoice_Request_Status_Reference = array(), $invoice_Request_Date_On_or_After = null, $invoice_Request_Date_On_or_Before = null, $invoice_Request_Due_Date_On_or_After = null, $invoice_Request_Due_Date_On_or_Before = null, array $created_by_Worker_Reference = array(), array $approved_by_Worker_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setCompany_Reference($company_Reference)
            ->setInvoice_Request_Status_Reference($invoice_Request_Status_Reference)
            ->setInvoice_Request_Date_On_or_After($invoice_Request_Date_On_or_After)
            ->setInvoice_Request_Date_On_or_Before($invoice_Request_Date_On_or_Before)
            ->setInvoice_Request_Due_Date_On_or_After($invoice_Request_Due_Date_On_or_After)
            ->setInvoice_Request_Due_Date_On_or_Before($invoice_Request_Due_Date_On_or_Before)
            ->setCreated_by_Worker_Reference($created_by_Worker_Reference)
            ->setApproved_by_Worker_Reference($approved_by_Worker_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Invoice_Request_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Invoice_Request_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Request_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getInvoice_Request_Status_Reference()
    {
        return $this->Invoice_Request_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Request_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Request_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Request_Status_ReferenceForArrayConstraintsFromSetInvoice_Request_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem) ? get_class($supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem), var_export($supplier_Invoice_Request_Request_CriteriaTypeInvoice_Request_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Request_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Request_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $invoice_Request_Status_Reference
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setInvoice_Request_Status_Reference(array $invoice_Request_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Request_Status_ReferenceArrayErrorMessage = self::validateInvoice_Request_Status_ReferenceForArrayConstraintsFromSetInvoice_Request_Status_Reference($invoice_Request_Status_Reference))) {
            throw new \InvalidArgumentException($invoice_Request_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Request_Status_Reference = $invoice_Request_Status_Reference;
        return $this;
    }
    /**
     * Add item to Invoice_Request_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function addToInvoice_Request_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Request_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Request_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Request_Date_On_or_After value
     * @return string|null
     */
    public function getInvoice_Request_Date_On_or_After()
    {
        return $this->Invoice_Request_Date_On_or_After;
    }
    /**
     * Set Invoice_Request_Date_On_or_After value
     * @param string $invoice_Request_Date_On_or_After
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setInvoice_Request_Date_On_or_After($invoice_Request_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Request_Date_On_or_After) && !is_string($invoice_Request_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Request_Date_On_or_After, true), gettype($invoice_Request_Date_On_or_After)), __LINE__);
        }
        $this->Invoice_Request_Date_On_or_After = $invoice_Request_Date_On_or_After;
        return $this;
    }
    /**
     * Get Invoice_Request_Date_On_or_Before value
     * @return string|null
     */
    public function getInvoice_Request_Date_On_or_Before()
    {
        return $this->Invoice_Request_Date_On_or_Before;
    }
    /**
     * Set Invoice_Request_Date_On_or_Before value
     * @param string $invoice_Request_Date_On_or_Before
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setInvoice_Request_Date_On_or_Before($invoice_Request_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Request_Date_On_or_Before) && !is_string($invoice_Request_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Request_Date_On_or_Before, true), gettype($invoice_Request_Date_On_or_Before)), __LINE__);
        }
        $this->Invoice_Request_Date_On_or_Before = $invoice_Request_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Invoice_Request_Due_Date_On_or_After value
     * @return string|null
     */
    public function getInvoice_Request_Due_Date_On_or_After()
    {
        return $this->Invoice_Request_Due_Date_On_or_After;
    }
    /**
     * Set Invoice_Request_Due_Date_On_or_After value
     * @param string $invoice_Request_Due_Date_On_or_After
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setInvoice_Request_Due_Date_On_or_After($invoice_Request_Due_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Request_Due_Date_On_or_After) && !is_string($invoice_Request_Due_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Request_Due_Date_On_or_After, true), gettype($invoice_Request_Due_Date_On_or_After)), __LINE__);
        }
        $this->Invoice_Request_Due_Date_On_or_After = $invoice_Request_Due_Date_On_or_After;
        return $this;
    }
    /**
     * Get Invoice_Request_Due_Date_On_or_Before value
     * @return string|null
     */
    public function getInvoice_Request_Due_Date_On_or_Before()
    {
        return $this->Invoice_Request_Due_Date_On_or_Before;
    }
    /**
     * Set Invoice_Request_Due_Date_On_or_Before value
     * @param string $invoice_Request_Due_Date_On_or_Before
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setInvoice_Request_Due_Date_On_or_Before($invoice_Request_Due_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Request_Due_Date_On_or_Before) && !is_string($invoice_Request_Due_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Request_Due_Date_On_or_Before, true), gettype($invoice_Request_Due_Date_On_or_Before)), __LINE__);
        }
        $this->Invoice_Request_Due_Date_On_or_Before = $invoice_Request_Due_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Created_by_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreated_by_Worker_Reference()
    {
        return $this->Created_by_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_by_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_by_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_by_Worker_ReferenceForArrayConstraintsFromSetCreated_by_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) ? get_class($supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem), var_export($supplier_Invoice_Request_Request_CriteriaTypeCreated_by_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $created_by_Worker_Reference
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setCreated_by_Worker_Reference(array $created_by_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_by_Worker_ReferenceArrayErrorMessage = self::validateCreated_by_Worker_ReferenceForArrayConstraintsFromSetCreated_by_Worker_Reference($created_by_Worker_Reference))) {
            throw new \InvalidArgumentException($created_by_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_by_Worker_Reference = $created_by_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Created_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function addToCreated_by_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_by_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approved_by_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproved_by_Worker_Reference()
    {
        return $this->Approved_by_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproved_by_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproved_by_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproved_by_Worker_ReferenceForArrayConstraintsFromSetApproved_by_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem) ? get_class($supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem), var_export($supplier_Invoice_Request_Request_CriteriaTypeApproved_by_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approved_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approved_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approved_by_Worker_Reference
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function setApproved_by_Worker_Reference(array $approved_by_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approved_by_Worker_ReferenceArrayErrorMessage = self::validateApproved_by_Worker_ReferenceForArrayConstraintsFromSetApproved_by_Worker_Reference($approved_by_Worker_Reference))) {
            throw new \InvalidArgumentException($approved_by_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approved_by_Worker_Reference = $approved_by_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Approved_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Request_CriteriaType
     */
    public function addToApproved_by_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approved_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approved_by_Worker_Reference[] = $item;
        return $this;
    }
}
