<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Adjustment_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Supplier Invoice Adjustment
 * @subpackage Structs
 */
class Supplier_Invoice_Adjustment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Adjustment
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_AdjustmentObjectType[]
     */
    public $Supplier_Invoice_Adjustment_Reference;
    /**
     * Constructor method for Supplier_Invoice_Adjustment_Request_ReferencesType
     * @uses Supplier_Invoice_Adjustment_Request_ReferencesType::setSupplier_Invoice_Adjustment_Reference()
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType[] $supplier_Invoice_Adjustment_Reference
     */
    public function __construct(array $supplier_Invoice_Adjustment_Reference = array())
    {
        $this
            ->setSupplier_Invoice_Adjustment_Reference($supplier_Invoice_Adjustment_Reference);
    }
    /**
     * Get Supplier_Invoice_Adjustment_Reference value
     * @return \StructType\Supplier_Invoice_AdjustmentObjectType[]|null
     */
    public function getSupplier_Invoice_Adjustment_Reference()
    {
        return $this->Supplier_Invoice_Adjustment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Adjustment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Adjustment_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Adjustment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem instanceof \StructType\Supplier_Invoice_AdjustmentObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_ReferencesTypeSupplier_Invoice_Adjustment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Adjustment_Reference property can only contain items of type \StructType\Supplier_Invoice_AdjustmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType[] $supplier_Invoice_Adjustment_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_ReferencesType
     */
    public function setSupplier_Invoice_Adjustment_Reference(array $supplier_Invoice_Adjustment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Adjustment_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Adjustment_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Adjustment_Reference($supplier_Invoice_Adjustment_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Adjustment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Adjustment_Reference = $supplier_Invoice_Adjustment_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_ReferencesType
     */
    public function addToSupplier_Invoice_Adjustment_Reference(\StructType\Supplier_Invoice_AdjustmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_AdjustmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Adjustment_Reference property can only contain items of type \StructType\Supplier_Invoice_AdjustmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Adjustment_Reference[] = $item;
        return $this;
    }
}
