<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Service_Line_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Only one worktag for each type is allowed for each document line. | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Supplier Contract Service Line Replacement Data
 * @subpackage Structs
 */
class Supplier_Contract_Service_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line NumbercXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@lineNumber | Purchase Order Line Number from which the business asset was ordered | This is the Supplier Contract Line Number for the Supplier
     * Contract Line you wish to put on Hold. | RFQ Line Number | The line number of the Purchase Order. | Line Number
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * @var string
     */
    public $Line_Number;
    /**
     * The Company_for_Invoices_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Invoices Reference
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_for_Invoices_Reference;
    /**
     * The Line_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Contract Line On Hold
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Line_On_Hold;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Recoverabilities_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Recoverabilities_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Charge_Control_Data
     * Meta information extracted from the WSDL
     * - documentation: Service line charge control amounts
     * - minOccurs: 0
     * @var \StructType\Charge_Control_DataType
     */
    public $Charge_Control_Data;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Supplier_Contract_Line_Renewal_Data
     * Meta information extracted from the WSDL
     * - documentation: Renewal Data for Contract Line. Only used on Contracts supporting Renewals and Contracts and has Contract Line End Date.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public $Supplier_Contract_Line_Renewal_Data;
    /**
     * The Retention
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. If not specified for a Supplier Contract Line that supports Scheduled PO contract type, Workday will default the Purchase Order Ship-To Address specified on the Contract Header.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Location Reference
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Related_Document_Lines_Reference
     * Meta information extracted from the WSDL
     * - documentation: Represents all the lines this contract line is related to. This field is used for view purposes only.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_LineObjectType[]
     */
    public $Related_Document_Lines_Reference;
    /**
     * Constructor method for Supplier_Contract_Service_Line_Replacement_DataType
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setLine_Number()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setCompany_for_Invoices_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setLine_On_Hold()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setItem_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setDescription()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setSpend_Category_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setTax_Applicability_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setTax_Code_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setTax_Rate_Recoverabilities_Data()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setExtended_Amount()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setCharge_Control_Data()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setStart_Date()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setEnd_Date()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setSupplier_Contract_Line_Renewal_Data()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setRetention()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setMemo()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setLocation_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setWorktag_Reference()
     * @uses Supplier_Contract_Service_Line_Replacement_DataType::setRelated_Document_Lines_Reference()
     * @param string $line_Number
     * @param \StructType\CompanyObjectType $company_for_Invoices_Reference
     * @param bool $line_On_Hold
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @param float $extended_Amount
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data
     * @param bool $retention
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param string $memo
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Business_Document_LineObjectType[] $related_Document_Lines_Reference
     */
    public function __construct($line_Number = null, \StructType\CompanyObjectType $company_for_Invoices_Reference = null, $line_On_Hold = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null, $extended_Amount = null, \StructType\Charge_Control_DataType $charge_Control_Data = null, $start_Date = null, $end_Date = null, \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data = null, $retention = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, $memo = null, \StructType\LocationObjectType $location_Reference = null, array $worktag_Reference = array(), array $related_Document_Lines_Reference = array())
    {
        $this
            ->setLine_Number($line_Number)
            ->setCompany_for_Invoices_Reference($company_for_Invoices_Reference)
            ->setLine_On_Hold($line_On_Hold)
            ->setItem_Reference($item_Reference)
            ->setDescription($description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data)
            ->setExtended_Amount($extended_Amount)
            ->setCharge_Control_Data($charge_Control_Data)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setSupplier_Contract_Line_Renewal_Data($supplier_Contract_Line_Renewal_Data)
            ->setRetention($retention)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setMemo($memo)
            ->setLocation_Reference($location_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setRelated_Document_Lines_Reference($related_Document_Lines_Reference);
    }
    /**
     * Get Line_Number value
     * @return string|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param string $line_Number
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: string
        if (!is_null($line_Number) && !is_string($line_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($line_Number) && mb_strlen($line_Number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($line_Number)), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Company_for_Invoices_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_for_Invoices_Reference()
    {
        return $this->Company_for_Invoices_Reference;
    }
    /**
     * Set Company_for_Invoices_Reference value
     * @param \StructType\CompanyObjectType $company_for_Invoices_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setCompany_for_Invoices_Reference(\StructType\CompanyObjectType $company_for_Invoices_Reference = null)
    {
        $this->Company_for_Invoices_Reference = $company_for_Invoices_Reference;
        return $this;
    }
    /**
     * Get Line_On_Hold value
     * @return bool|null
     */
    public function getLine_On_Hold()
    {
        return $this->Line_On_Hold;
    }
    /**
     * Set Line_On_Hold value
     * @param bool $line_On_Hold
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setLine_On_Hold($line_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($line_On_Hold) && !is_bool($line_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($line_On_Hold, true), gettype($line_On_Hold)), __LINE__);
        }
        $this->Line_On_Hold = $line_On_Hold;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Recoverabilities_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Recoverabilities_Data()
    {
        return $this->Tax_Rate_Recoverabilities_Data;
    }
    /**
     * Set Tax_Rate_Recoverabilities_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setTax_Rate_Recoverabilities_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null)
    {
        $this->Tax_Rate_Recoverabilities_Data = $tax_Rate_Recoverabilities_Data;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Charge_Control_Data value
     * @return \StructType\Charge_Control_DataType|null
     */
    public function getCharge_Control_Data()
    {
        return $this->Charge_Control_Data;
    }
    /**
     * Set Charge_Control_Data value
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setCharge_Control_Data(\StructType\Charge_Control_DataType $charge_Control_Data = null)
    {
        $this->Charge_Control_Data = $charge_Control_Data;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Renewal_Data value
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType|null
     */
    public function getSupplier_Contract_Line_Renewal_Data()
    {
        return $this->Supplier_Contract_Line_Renewal_Data;
    }
    /**
     * Set Supplier_Contract_Line_Renewal_Data value
     * @param \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Renewal_Data(\StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data = null)
    {
        $this->Supplier_Contract_Line_Renewal_Data = $supplier_Contract_Line_Renewal_Data;
        return $this;
    }
    /**
     * Get Retention value
     * @return bool|null
     */
    public function getRetention()
    {
        return $this->Retention;
    }
    /**
     * Set Retention value
     * @param bool $retention
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention) && !is_bool($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention, true), gettype($retention)), __LINE__);
        }
        $this->Retention = $retention;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem) ? get_class($supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem), var_export($supplier_Contract_Service_Line_Replacement_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Related_Document_Lines_Reference value
     * @return \StructType\Business_Document_LineObjectType[]|null
     */
    public function getRelated_Document_Lines_Reference()
    {
        return $this->Related_Document_Lines_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Document_Lines_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Document_Lines_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Document_Lines_ReferenceForArrayConstraintsFromSetRelated_Document_Lines_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem instanceof \StructType\Business_Document_LineObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) ? get_class($supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem), var_export($supplier_Contract_Service_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Document_Lines_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Document_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType[] $related_Document_Lines_Reference
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function setRelated_Document_Lines_Reference(array $related_Document_Lines_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Document_Lines_ReferenceArrayErrorMessage = self::validateRelated_Document_Lines_ReferenceForArrayConstraintsFromSetRelated_Document_Lines_Reference($related_Document_Lines_Reference))) {
            throw new \InvalidArgumentException($related_Document_Lines_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Related_Document_Lines_Reference = $related_Document_Lines_Reference;
        return $this;
    }
    /**
     * Add item to Related_Document_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType $item
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType
     */
    public function addToRelated_Document_Lines_Reference(\StructType\Business_Document_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Related_Document_Lines_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Document_Lines_Reference[] = $item;
        return $this;
    }
}
