<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Participant_List_Entry_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Participant List Entry Data
 * @subpackage Structs
 */
class Supplier_Contract_Participant_List_Entry_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Inactive_as_List_Entry
     * Meta information extracted from the WSDL
     * - documentation: Inactive as List Entry
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive_as_List_Entry;
    /**
     * Constructor method for Supplier_Contract_Participant_List_Entry_DataType
     * @uses Supplier_Contract_Participant_List_Entry_DataType::setCompany_Reference()
     * @uses Supplier_Contract_Participant_List_Entry_DataType::setInactive_as_List_Entry()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $inactive_as_List_Entry
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, $inactive_as_List_Entry = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setInactive_as_List_Entry($inactive_as_List_Entry);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Contract_Participant_List_Entry_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Inactive_as_List_Entry value
     * @return bool|null
     */
    public function getInactive_as_List_Entry()
    {
        return $this->Inactive_as_List_Entry;
    }
    /**
     * Set Inactive_as_List_Entry value
     * @param bool $inactive_as_List_Entry
     * @return \StructType\Supplier_Contract_Participant_List_Entry_DataType
     */
    public function setInactive_as_List_Entry($inactive_as_List_Entry = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive_as_List_Entry) && !is_bool($inactive_as_List_Entry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive_as_List_Entry, true), gettype($inactive_as_List_Entry)), __LINE__);
        }
        $this->Inactive_as_List_Entry = $inactive_as_List_Entry;
        return $this;
    }
}
