<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Lease_Amendment_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains criteria to find Supplier Contract Lease Amendments
 * @subpackage Structs
 */
class Supplier_Contract_Lease_Amendment_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Lease_Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference for Amendment
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Lease_Supplier_Contract_Reference;
    /**
     * Constructor method for Supplier_Contract_Lease_Amendment_Request_CriteriaType
     * @uses Supplier_Contract_Lease_Amendment_Request_CriteriaType::setLease_Supplier_Contract_Reference()
     * @param \StructType\Supplier_ContractObjectType[] $lease_Supplier_Contract_Reference
     */
    public function __construct(array $lease_Supplier_Contract_Reference = array())
    {
        $this
            ->setLease_Supplier_Contract_Reference($lease_Supplier_Contract_Reference);
    }
    /**
     * Get Lease_Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getLease_Supplier_Contract_Reference()
    {
        return $this->Lease_Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLease_Supplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLease_Supplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLease_Supplier_Contract_ReferenceForArrayConstraintsFromSetLease_Supplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem) ? get_class($supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem), var_export($supplier_Contract_Lease_Amendment_Request_CriteriaTypeLease_Supplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lease_Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lease_Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $lease_Supplier_Contract_Reference
     * @return \StructType\Supplier_Contract_Lease_Amendment_Request_CriteriaType
     */
    public function setLease_Supplier_Contract_Reference(array $lease_Supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($lease_Supplier_Contract_ReferenceArrayErrorMessage = self::validateLease_Supplier_Contract_ReferenceForArrayConstraintsFromSetLease_Supplier_Contract_Reference($lease_Supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($lease_Supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Lease_Supplier_Contract_Reference = $lease_Supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Lease_Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Supplier_Contract_Lease_Amendment_Request_CriteriaType
     */
    public function addToLease_Supplier_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Lease_Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lease_Supplier_Contract_Reference[] = $item;
        return $this;
    }
}
