<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Installment_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Invoice Schedule Installment Line data
 * @subpackage Structs
 */
class Supplier_Contract_Installment_Line_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is a reference to an existing Supplier Contract Line that isn't used by another Supplier Contract type Schedule.
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Line order
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Use_Line_Overrides
     * Meta information extracted from the WSDL
     * - documentation: Override Line flag. Use this to specify values on the installment line instead of using values derived from either the installment, the schedule, or the contract line. This must be on to specify overrides.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Line_Overrides;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: From Date. If you supply this value as an override, you must also enable the Override Line flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The To_Date
     * Meta information extracted from the WSDL
     * - documentation: To Date. If you supply this value as an override, you must also enable the Override Line flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Date;
    /**
     * The Payment_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Payment Amount is equal to the extended amount minus the retention amount. This field only returns values. | The total amount minus the retention amount. This field is for returning values only. Any values entered will be
     * ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Payment_Amount;
    /**
     * The Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount to report for the expense. This will only be used for viewing. | Installment Line Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Amount;
    /**
     * The Retention_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount to retain from the scheduled supplier invoice installment. | The amount to retain from this invoice line.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Retention_Amount;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Unit of Measure. If you supply this value as an override, you must also enable the Override Line flag.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Line_Description
     * Meta information extracted from the WSDL
     * - documentation: Installment Line Description from Supplier Contract type Installment Line or from Supplier Contract Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags from Override or from Supplier Contract Line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Supplier_Contract_Installment_Line_DataType
     * @uses Supplier_Contract_Installment_Line_DataType::setSupplier_Contract_Line_Reference()
     * @uses Supplier_Contract_Installment_Line_DataType::setLine_Order()
     * @uses Supplier_Contract_Installment_Line_DataType::setUse_Line_Overrides()
     * @uses Supplier_Contract_Installment_Line_DataType::setQuantity()
     * @uses Supplier_Contract_Installment_Line_DataType::setUnit_Cost()
     * @uses Supplier_Contract_Installment_Line_DataType::setFrom_Date()
     * @uses Supplier_Contract_Installment_Line_DataType::setTo_Date()
     * @uses Supplier_Contract_Installment_Line_DataType::setPayment_Amount()
     * @uses Supplier_Contract_Installment_Line_DataType::setTotal_Amount()
     * @uses Supplier_Contract_Installment_Line_DataType::setRetention_Amount()
     * @uses Supplier_Contract_Installment_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Supplier_Contract_Installment_Line_DataType::setLine_Description()
     * @uses Supplier_Contract_Installment_Line_DataType::setSpend_Category_Reference()
     * @uses Supplier_Contract_Installment_Line_DataType::setWorktags_Reference()
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param string $line_Order
     * @param bool $use_Line_Overrides
     * @param float $quantity
     * @param float $unit_Cost
     * @param string $from_Date
     * @param string $to_Date
     * @param float $payment_Amount
     * @param float $total_Amount
     * @param float $retention_Amount
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param string $line_Description
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, $line_Order = null, $use_Line_Overrides = null, $quantity = null, $unit_Cost = null, $from_Date = null, $to_Date = null, $payment_Amount = null, $total_Amount = null, $retention_Amount = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $line_Description = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, array $worktags_Reference = array())
    {
        $this
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setLine_Order($line_Order)
            ->setUse_Line_Overrides($use_Line_Overrides)
            ->setQuantity($quantity)
            ->setUnit_Cost($unit_Cost)
            ->setFrom_Date($from_Date)
            ->setTo_Date($to_Date)
            ->setPayment_Amount($payment_Amount)
            ->setTotal_Amount($total_Amount)
            ->setRetention_Amount($retention_Amount)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setLine_Description($line_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Use_Line_Overrides value
     * @return bool|null
     */
    public function getUse_Line_Overrides()
    {
        return $this->Use_Line_Overrides;
    }
    /**
     * Set Use_Line_Overrides value
     * @param bool $use_Line_Overrides
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setUse_Line_Overrides($use_Line_Overrides = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Line_Overrides) && !is_bool($use_Line_Overrides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Line_Overrides, true), gettype($use_Line_Overrides)), __LINE__);
        }
        $this->Use_Line_Overrides = $use_Line_Overrides;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get To_Date value
     * @return string|null
     */
    public function getTo_Date()
    {
        return $this->To_Date;
    }
    /**
     * Set To_Date value
     * @param string $to_Date
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setTo_Date($to_Date = null)
    {
        // validation for constraint: string
        if (!is_null($to_Date) && !is_string($to_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Date, true), gettype($to_Date)), __LINE__);
        }
        $this->To_Date = $to_Date;
        return $this;
    }
    /**
     * Get Payment_Amount value
     * @return float|null
     */
    public function getPayment_Amount()
    {
        return $this->Payment_Amount;
    }
    /**
     * Set Payment_Amount value
     * @param float $payment_Amount
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setPayment_Amount($payment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($payment_Amount) && !(is_float($payment_Amount) || is_numeric($payment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payment_Amount, true), gettype($payment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($payment_Amount) && mb_strlen(mb_substr($payment_Amount, false !== mb_strpos($payment_Amount, '.') ? mb_strpos($payment_Amount, '.') + 1 : mb_strlen($payment_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($payment_Amount, true), mb_strlen(mb_substr($payment_Amount, mb_strpos($payment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($payment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $payment_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($payment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $payment_Amount))), __LINE__);
        }
        $this->Payment_Amount = $payment_Amount;
        return $this;
    }
    /**
     * Get Total_Amount value
     * @return float|null
     */
    public function getTotal_Amount()
    {
        return $this->Total_Amount;
    }
    /**
     * Set Total_Amount value
     * @param float $total_Amount
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setTotal_Amount($total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Amount) && !(is_float($total_Amount) || is_numeric($total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Amount, true), gettype($total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Amount) && mb_strlen(mb_substr($total_Amount, false !== mb_strpos($total_Amount, '.') ? mb_strpos($total_Amount, '.') + 1 : mb_strlen($total_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Amount, true), mb_strlen(mb_substr($total_Amount, mb_strpos($total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Amount))), __LINE__);
        }
        $this->Total_Amount = $total_Amount;
        return $this;
    }
    /**
     * Get Retention_Amount value
     * @return float|null
     */
    public function getRetention_Amount()
    {
        return $this->Retention_Amount;
    }
    /**
     * Set Retention_Amount value
     * @param float $retention_Amount
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setRetention_Amount($retention_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($retention_Amount) && !(is_float($retention_Amount) || is_numeric($retention_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retention_Amount, true), gettype($retention_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($retention_Amount) && mb_strlen(mb_substr($retention_Amount, false !== mb_strpos($retention_Amount, '.') ? mb_strpos($retention_Amount, '.') + 1 : mb_strlen($retention_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($retention_Amount, true), mb_strlen(mb_substr($retention_Amount, mb_strpos($retention_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($retention_Amount) && $retention_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($retention_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($retention_Amount) && mb_strlen(preg_replace('/(\D)/', '', $retention_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($retention_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $retention_Amount))), __LINE__);
        }
        $this->Retention_Amount = $retention_Amount;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Line_Description value
     * @return string|null
     */
    public function getLine_Description()
    {
        return $this->Line_Description;
    }
    /**
     * Set Line_Description value
     * @param string $line_Description
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setLine_Description($line_Description = null)
    {
        // validation for constraint: string
        if (!is_null($line_Description) && !is_string($line_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Description, true), gettype($line_Description)), __LINE__);
        }
        $this->Line_Description = $line_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem) ? get_class($supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem), var_export($supplier_Contract_Installment_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Contract_Installment_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
