<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Supplier Classification
 * @subpackage Structs
 */
class Supplier_Classification_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Classification
     * - maxOccurs: unbounded
     * @var \StructType\Custom_Supplier_ClassificationObjectType[]
     */
    public $Supplier_Classification_Reference;
    /**
     * Constructor method for Supplier_Classification_Request_ReferencesType
     * @uses Supplier_Classification_Request_ReferencesType::setSupplier_Classification_Reference()
     * @param \StructType\Custom_Supplier_ClassificationObjectType[] $supplier_Classification_Reference
     */
    public function __construct(array $supplier_Classification_Reference = array())
    {
        $this
            ->setSupplier_Classification_Reference($supplier_Classification_Reference);
    }
    /**
     * Get Supplier_Classification_Reference value
     * @return \StructType\Custom_Supplier_ClassificationObjectType[]|null
     */
    public function getSupplier_Classification_Reference()
    {
        return $this->Supplier_Classification_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_ReferenceForArrayConstraintsFromSetSupplier_Classification_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem instanceof \StructType\Custom_Supplier_ClassificationObjectType) {
                $invalidValues[] = is_object($supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem) ? get_class($supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem), var_export($supplier_Classification_Request_ReferencesTypeSupplier_Classification_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Reference property can only contain items of type \StructType\Custom_Supplier_ClassificationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_ClassificationObjectType[] $supplier_Classification_Reference
     * @return \StructType\Supplier_Classification_Request_ReferencesType
     */
    public function setSupplier_Classification_Reference(array $supplier_Classification_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_ReferenceArrayErrorMessage = self::validateSupplier_Classification_ReferenceForArrayConstraintsFromSetSupplier_Classification_Reference($supplier_Classification_Reference))) {
            throw new \InvalidArgumentException($supplier_Classification_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Reference = $supplier_Classification_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Supplier_ClassificationObjectType $item
     * @return \StructType\Supplier_Classification_Request_ReferencesType
     */
    public function addToSupplier_Classification_Reference(\StructType\Custom_Supplier_ClassificationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_Supplier_ClassificationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Reference property can only contain items of type \StructType\Custom_Supplier_ClassificationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Reference[] = $item;
        return $this;
    }
}
