<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Catalog_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Supplier Reference provided is not valid for Supplier Catalogs. | Element containing the criteria for retrieving Supplier Catalogs.
 * @subpackage Structs
 */
class Supplier_Catalog_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Catalog_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalog Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Catalog_Name;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier. Note that this cannot be an Internal Service Provider.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * Constructor method for Supplier_Catalog_Request_CriteriaType
     * @uses Supplier_Catalog_Request_CriteriaType::setCatalog_Name()
     * @uses Supplier_Catalog_Request_CriteriaType::setCurrency_Reference()
     * @uses Supplier_Catalog_Request_CriteriaType::setSupplier_Reference()
     * @param string $catalog_Name
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     */
    public function __construct($catalog_Name = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this
            ->setCatalog_Name($catalog_Name)
            ->setCurrency_Reference($currency_Reference)
            ->setSupplier_Reference($supplier_Reference);
    }
    /**
     * Get Catalog_Name value
     * @return string|null
     */
    public function getCatalog_Name()
    {
        return $this->Catalog_Name;
    }
    /**
     * Set Catalog_Name value
     * @param string $catalog_Name
     * @return \StructType\Supplier_Catalog_Request_CriteriaType
     */
    public function setCatalog_Name($catalog_Name = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Name) && !is_string($catalog_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Name, true), gettype($catalog_Name)), __LINE__);
        }
        $this->Catalog_Name = $catalog_Name;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Catalog_Request_CriteriaType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Catalog_Request_CriteriaType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
}
