<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Data is required. | The Web Service is set to Add Only; but the Supplier already exists. | Element containing Supplier Business Processing Options, Supplier reference for update. Flag to indicate if this operation is add
 * only, and all Supplier data items required to create a complete Supplier
 * @subpackage Structs
 */
class Submit_Supplier_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Data
     * @var \StructType\Supplier_DataType
     */
    public $Supplier_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * Constructor method for Submit_Supplier_RequestType
     * @uses Submit_Supplier_RequestType::setSupplier_Reference()
     * @uses Submit_Supplier_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_RequestType::setSupplier_Data()
     * @uses Submit_Supplier_RequestType::setAdd_Only()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_DataType $supplier_Data
     * @param bool $add_Only
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_DataType $supplier_Data = null, $add_Only = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Data($supplier_Data)
            ->setAdd_Only($add_Only);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Submit_Supplier_RequestType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Data value
     * @return \StructType\Supplier_DataType|null
     */
    public function getSupplier_Data()
    {
        return $this->Supplier_Data;
    }
    /**
     * Set Supplier_Data value
     * @param \StructType\Supplier_DataType $supplier_Data
     * @return \StructType\Submit_Supplier_RequestType
     */
    public function setSupplier_Data(\StructType\Supplier_DataType $supplier_Data = null)
    {
        $this->Supplier_Data = $supplier_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
}
