<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Invoice_Contract_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This Recurring Supplier Invoice is not in Draft Status so it cannot be resubmitted. | The Web Service is set to Add Only; but the Recurring Supplier Invoice already exists. | Submit Supplier Invoice Contract Request
 * @subpackage Structs
 */
class Submit_Supplier_Invoice_Contract_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Recurring Supplier Invoice for update only purposes. Supplier Invoice Contract was renamed to Recurring Supplier Invoice and refer to the same business object.
     * - minOccurs: 0
     * @var \StructType\Recurring_Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Contract_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Invoice_Contract_Data
     * Meta information extracted from the WSDL
     * - documentation: Recurring Supplier Invoice Data
     * - minOccurs: 0
     * @var \StructType\Recurring_Supplier_Invoice_DataType
     */
    public $Supplier_Invoice_Contract_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Invoice_Contract_RequestType
     * @uses Submit_Supplier_Invoice_Contract_RequestType::setSupplier_Invoice_Contract_Reference()
     * @uses Submit_Supplier_Invoice_Contract_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Invoice_Contract_RequestType::setSupplier_Invoice_Contract_Data()
     * @uses Submit_Supplier_Invoice_Contract_RequestType::setAdd_Only()
     * @uses Submit_Supplier_Invoice_Contract_RequestType::setVersion()
     * @param \StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\Recurring_Supplier_Invoice_DataType $supplier_Invoice_Contract_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference = null, array $business_Process_Parameters = array(), \StructType\Recurring_Supplier_Invoice_DataType $supplier_Invoice_Contract_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Contract_Reference($supplier_Invoice_Contract_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Invoice_Contract_Data($supplier_Invoice_Contract_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Contract_Reference value
     * @return \StructType\Recurring_Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Contract_Reference()
    {
        return $this->Supplier_Invoice_Contract_Reference;
    }
    /**
     * Set Supplier_Invoice_Contract_Reference value
     * @param \StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function setSupplier_Invoice_Contract_Reference(\StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference = null)
    {
        $this->Supplier_Invoice_Contract_Reference = $supplier_Invoice_Contract_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem) ? get_class($submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem), var_export($submit_Supplier_Invoice_Contract_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Contract_Data value
     * @return \StructType\Recurring_Supplier_Invoice_DataType|null
     */
    public function getSupplier_Invoice_Contract_Data()
    {
        return $this->Supplier_Invoice_Contract_Data;
    }
    /**
     * Set Supplier_Invoice_Contract_Data value
     * @param \StructType\Recurring_Supplier_Invoice_DataType $supplier_Invoice_Contract_Data
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function setSupplier_Invoice_Contract_Data(\StructType\Recurring_Supplier_Invoice_DataType $supplier_Invoice_Contract_Data = null)
    {
        $this->Supplier_Invoice_Contract_Data = $supplier_Invoice_Contract_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Invoice_Contract_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
